 <div class="table-responsive">
     <table id="example" class="table table-bordered align-middle" style="width:100%">
         <thead class="table-light">
             <tr>
                 <th class="thbutton">Sl No</th>
                 <th>Accounts Name</th>
                 <th>Account Type</th>
                 <!-- <th>Customer ID</th> -->
                 <th>Phone</th>
                 <th>Account Group</th>
                 <th>Address</th>
                 <th class="thbutton">Edit</th>
                 <th class="thbutton">Delete</th>
             </tr>
         </thead>
         <tbody>

             @if (count($data) > 0)
                 @foreach ($data as $key => $list)
                     <tr>
                         <td class="text-center">{{ $data->firstItem() + $key }}</td>
                         <td>{{ $list->account_name }} {{ $list->customer_id }}</td>
                         <td>{{ $list->account_type }}</td>
                         <td>{{ $list->phone }}</td>
                         <td>{{ $list->account_group }}</td>
                         <td>{{ $list->address }}</td>
                         <td>
                             <button data-id="{!! $list->id !!}" class="btn btn-warning edit"
                                 data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit"><i
                                     class="bi bi-pencil-square text-white"></i></button>
                         </td>
                         <td>
                             <a data-url="{{ route('accounts-import.delete') }}" data-id="{{ $list->id }}"
                                 class="btn btn-danger deleteDataCustom" href="#" class="text-danger"
                                 data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                 <i class="bi bi-trash text-white"></i>
                             </a>
                         </td>
                     </tr>
                 @endforeach
             @else
                 <tr>
                     <td colspan="13">No Data Found</td>
                 </tr>
             @endif
         </tbody>
     </table>
 </div>
 <nav class="row align-items-center mt-3">
     <div class="col-md-7">
         {!! $data->onEachSide(0)->render('temp-accounts-import.pagination') !!}
     </div>
     <div class="col-md-5" style="display: flex; justify-content: space-between;">
         <div class="btn-group mb-0">
             <a href="{{ route('account-import-create') }}" class="btn btn-outline-primary"><i class="bx bx-upload"></i>
                 Import Accounts From Excel</a>
         </div>

         <div class="btn-group mb-0">
             <a href="{!! route('accounts-import.export-sample') !!}" class="btn btn-outline-primary mx-2" target="_blank"><i
                     class="bi bi-cloud-download"></i> Download Sample</a>
         </div>
     </div>
 </nav>
 </div>
