<form class="row g-3 auto-width primary_unit" method="post" action="{{ route('test-item-normal-ranges.update', $range->id) }}" id="primary_unit_form">
    @csrf
    @method('post')
    <div class="col-6">
        <label for="gender" class="form-label">Gender<span class="text-danger"><b>*</b></span>
        </label>
        <select name="gender_id" class="form-control">
            @foreach($genders as $gender)
                <option {{ matchSelected($range->gender_id, $gender->id) }} value="{{ $gender->id }}">{{ $gender->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_gender_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-6">
        <label for="age factor" class="form-label">Age Factor<span class="text-danger"><b>*</b></span></label>
        <select class="form-control age_factor" name="age_factor">
            <option {{ matchSelected($range->age_factor, 'Years') }} value="Years">Years</option>
            <option {{ matchSelected($range->age_factor, 'Hours') }} value="Hours">Hours</option>
            <option {{ matchSelected($range->age_factor, 'Days') }} value="Days">Days</option>
        </select>
        <span class="text-danger error_age_factor" style="display:none;">This field is required.</span>
    </div>

    <div class="col-6">
        <label for="from age" class="form-label">Min Age <span class="age_factor_name"><span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="from_age" aria-describedby="inputGroupPrepend"
        value="{!! ($range->age_factor == 'Years') ? hoursToYears($range->from_age) : 
        ($range->age_factor == 'Days' ? hoursToDays($range->from_age) : $range->from_age) !!}">

        <span class="text-danger error_from_age" style="display:none;">This field is required.</span>
        <span class="text-danger error_min_age" style="display:none;">Min Age should be less than Max Age.</span>
    </div>

    <div class="col-6">
        <label for="to age" class="form-label">Max Age <span class="age_factor_name"><span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="to_age" aria-describedby="inputGroupPrepend"
        value="{!! ($range->age_factor == 'Years') ? hoursToYears($range->to_age) : 
            ($range->age_factor == 'Days' ? hoursToDays($range->to_age) : $range->to_age) !!}">

        <span class="text-danger error_to_age" style="display:none;">This field is required.</span>
    </div>

    <div class="col-6">
        <label for="low value" class="form-label">Min Value<span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" value="{{ $range->low_value }}" name="low_value" aria-describedby="inputGroupPrepend" placeholder="Min Value">
        <span class="text-danger error_low_value" style="display:none;">This field is required.</span>
        <span class="text-danger error_min_value" style="display:none;">Min Value should be less than Max Value</span>
    </div>

    <div class="col-6">
        <label for="high value" class="form-label">Max Value<span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" value="{{ $range->high_value }}" name="high_value" aria-describedby="inputGroupPrepend" placeholder="Max Value">
        <span class="text-danger error_high_value" style="display:none;">This field is required.</span>
    </div>

    <div class="col-6">
        <label for="special case" class="form-label">Special Case<span class="text-danger"><b>*</b></span>
        </label>
        <select name="special_case_id" class="form-control">
            @foreach($special_cases as $special_case)
                <option {{ matchSelected($range->special_case_id, $special_case->id) }} value="{{ $special_case->id }}">{{ $special_case->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_special_case_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-6">
        <label for="report output" class="form-label">Report Output</label>
        <input type="text" class="form-control" value="{{ $range->report_output }}" name="report_output" aria-describedby="inputGroupPrepend" placeholder="Report Output">
    </div>

</form>