<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
		        <th>Gender</th>
		        <th>Min Age</th>
		        <th>Max Age</th>
		        <th>Age Factor</th>
		        <th>Min Value</th>
		        <th>Max Value</th>
		        <th>Report Output</th>
		        <th>Special Case</th>
		        <th class="thbutton">Status</th>
		        @if(auth()->user()->can('test-item-normal-range-edit'))
		        	<th class="thbutton">Edit</th>
		        @endif
		        @if(auth()->user()->can('test-item-normal-range-delete'))
		        	<th class="thbutton">Delete</th>
		        @endif
		    </tr>
	    </thead>
	    <tbody> 
	    	@php $i=1;@endphp
            @if(isset($data) && count($data)>0)
		    	@foreach ($data as $key => $range)
				    <tr>
				        <td>{{$data->firstItem() + $key}}</td>
				        <td>{{ $range->gender }}</td>
				        <td>
				        	{!! ($range->age_factor == 'Years') ? hoursToYears($range->from_age) : 
				        	($range->age_factor == 'Days' ? hoursToDays($range->from_age) : $range->from_age) !!}
				        </td>
				        <td>
				        	{!! ($range->age_factor == 'Years') ? hoursToYears($range->to_age) : 
				        	($range->age_factor == 'Days' ? hoursToDays($range->to_age) : $range->to_age) !!}
				        </td>

				        <td>{{ $range->age_factor }}</td>
				        <td>{{ $range->low_value }}</td>
				        <td>{{ $range->high_value }}</td>
				        <td>{{ $range->report_output }}</td>
				        <td>{{ $range->special_case }}</td>
				        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-item-normal-ranges.changestatus')}}" data-id="{{$range->id}}" data-status="{{$range->status=='0' ? '1' : '0'}}" {{ $range->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(auth()->user()->can('test-item-normal-range-edit'))
                        <td>
                            <button data-id="{{ $range->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(auth()->user()->can('test-item-normal-range-delete'))
                        <td>
                            <a data-url="{{route('test-item-normal-ranges.destroy')}}" data-id="{{$range->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="12">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-6">
        {!! $data->onEachSide(0)->render('test-item-options.pagination') !!}
    </div>
	 @if(auth()->user()->can('test-item-normal-range-import'))
      <div class="col-md-6" style="text-align: right;">
        <div class="btn-group mb-0">
            <a class="btn btn-outline-primary" href="{!! route('test-item-normal-ranges.import-create', $item_id) !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
        </div>
      </div>
    @endif
</nav>
</div>