
@extends('layouts.app')
@section('title','Test Item Template')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
    .ck-file-dialog-button {
      display: none !important;
    }
    .ck-editor__editable_inline {
        min-height: 155px;
    }
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Test Item Template</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New Test Item Template</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('test-item-templates.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width test_item_template" method="post" action="{{ route('test-item-templates.store', $item_id) }}" id="template_form">
                        @csrf
                        @method('post')
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Item Test Template</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <label for="template_title" class="form-label">Title<span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="template_title" name="template_title" aria-describedby="inputGroupPrepend" placeholder="Enter Template Title" required>
                                        <span class="text-danger error_template_title" style="display:none;">This field is required.</span>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
                                        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
                                        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="template_text" class="form-label">Template Text </label>
                                        <textarea class="form-textarea" name="template_text"  rows="1"></textarea>
                                        <span class="text-danger error_template_text" style="display: none;">This field is required.</span>
                                    </div>
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary save_template"  type="button"><i class="bx bx-save"></i> Save Employee Details</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script>
  ClassicEditor
      .create( document.querySelector( '[name="template_text"]') )
      .then( newEditor => {
          editor = newEditor;
      })
      .catch( error => {
          console.error( error );
      });

      $(".ck-dropdown").find(`[data-cke-tooltip-text='Insert media']`).css("display", "none");
</script>
<script>
   $(document).on('click','.save_template', function(e) {
    e.preventDefault();

    $('.error_template_title').hide();
    $('.error_priority').hide();

    var error = 0;

    if ($('#template_form').find('input[name="template_title"]').val() == '') {
        $('.error_template_title').show();
        error = 1;
        setTimeout(function() {
            $('.error_template_title').hide();
        }, 3000);

    }
    if ($('#template_form').find('input[name="priority"]').val() == '') {
        $('.error_priority').show();
        error = 1;
        setTimeout(function() {
            $('.error_priority').hide();
        }, 3000);

    }

    if (error == 0) {

        let formdata = new FormData($('#template_form')[0]);
        formdata.append('template_text', editor.getData());

        $.ajax({
            url: "{{ route('test-item-templates.store', $item_id) }}",
            data: formdata,
            processData: false,
            contentType: false,
            type: 'POST',
            success: function(response) {
                if (response.success === true) {
                    toastr.success(response.message, 'Success.');
                    console.log('test');
                    window.location.href = "{{ route('test-item-templates.index',$item_id) }}";
                } else {
                    toastr.error(response.message, 'Error!');
                }
            }
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            console.log('AJAX request failed:', textStatus, errorThrown);
            toastr.error('An error occurred during the request.', 'Error!');
        });
    }
});

</script>
@endsection
