<style type="text/css">
    .dataTables_filter {
        display: none;
    }
</style>
@php $i=1;@endphp
@if(isset($groups) && count($groups) > 0)
    @foreach($groups as $key=> $group)
        <div class="card shadow-none radius-5 min-height test_package_groups mt-4">
            <div class="card-body">

                <div>
                    <div class="table-responsive row">
                        <div class="col-md-6 d-flex">
                            <h5 class="mb-0" style="white-space: break-spaces;">{{ $group->group_name }}</h5>

                            <div style="margin: 3px 0px 14px 20px;">
                                <div class="form-check form-check-inline{{$i}}">
                                    <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-package-groups.changestatus')}}" data-id="{{$group->id}}" data-status="{{$group->status=='0' ? '1' : '0'}}" {{ $group->status=='1' ? 'checked' : ''}}>
                                </div>
                            </div>
                             <hr class="mb-2">
                        </div>

                        <div class="col-lg-3 col-md-3 col-8">
                              <!-- <div class="position-relative">
                                  <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                                  <input class="form-control ps-5 test_package_search" type="search" id="" placeholder="Search">
                              </div> -->
                        </div>

                        <div class="col-md-3 d-flex justify-content-between">
                            @if(in_array('test-list-create', $authRolePermissions))
                            <div>
                                <a href="{{ route('test-items.create', $group->id) }}" class="btn btn-primary" ><i class="bx bx-plus"></i> Add Test Item</a>
                            </div>
                            @endif
                            @if(in_array('test-package-group-edit', $authRolePermissions))
                            <div>
                                <button data-id="{{ $group->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                </button>
                            </div>
                            @endif
                            @if(in_array('test-package-group-delete', $authRolePermissions) && count($groups)!=1)
                            <div>
                                <a data-url="{{route('test-package-groups.destroy', $group->test_package_id)}}" data-id="{{$group->id}}" class="btn btn-danger deleteData" href="#" class="text-danger" data-bs-toggle="tooltip"data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="card shadow-none radius-5 min-height test_package_groups">

            <table id="myTable" class="table table-bordered align-middle " style="width:100%">
                <thead class="table-light">
                    <tr>
                        <th class="thbutton">Sl No</th>
                        <th>Test Name</th>
                        <!-- <th>Method of Test</th> -->
                        <th>Priority</th>
                        <th>Range</th>
                        <th class="thbutton">Unit</th>
                        <th class="thbutton">Option</th>
                        <th class="thbutton">Range</th>
                        <th class="thbutton">Template</th>
                        <th class="thbutton" style="width: 9% !important;">Read Only</th>
                        <th class="thbutton">Status</th>
                        <th class="thbutton">Page Break</th>
                        @if(in_array('test-list-edit', $authRolePermissions))
                            <th class="thbutton">Edit</th>
                        @endif
                        @if(in_array('test-list-delete', $authRolePermissions))
                            <th class="thbutton">Remove</th>
                        @endif
                    </tr>
                </thead>
                <tbody class="tablecontents">
                    @php $sno = 1; @endphp
                    @if (isset($group->test_package_group_test_items) && count($group->test_package_group_test_items))
                        @foreach ($group->test_package_group_test_items as $test)
                            <tr style="cursor: move;" class="row1" data-id="{{ $test->id }}">
                                <td class="item_sno">{{ $sno++ }}</td>
                                <td>
                                    <a href="" data-id="{{ $test->test_item->id ?? '' }}" id="details" data-bs-toggle="modal" data-bs-target="#commonModal">{{ $test->test_item->test_name ?? '' }}</a><br>
                                    {{ $test->test_item->test_method_name ?? '' }}
                                    {{-- <small>{{ $test->test_item->test_code ?? '' }}</small> --}}
                                </td>
                                <td>
                                    {{ $test->priority }}<br>
                                </td>
                                <td>
                                    {!! $test->test_item->reference_value !!}
                                </td>
                                <td>
                                    {!! $test->test_item->unit !!}
                                </td>
                                <td>
                                    @if(isset($test->test_item->reference_value_type) && $test->test_item->reference_value_type == 'OPTIONS')
                                        <a href="{{ route('test-item-options.index', $test->test_item->id) }}" class="btn btn-success" ><i class="bi bi-layout-text-sidebar-reverse"></i></a>
                                    @else
                                        <a style="cursor: not-allowed;" class="btn btn-secondary" ><i class="bi bi-layout-text-sidebar-reverse"></i></a>
                                    @endif
                                </td>
                                
                                <td>
                                    @if(isset($test->test_item->reference_value_type) && $test->test_item->reference_value_type == 'RANGE')
                                        <a href="{{ route('test-item-normal-ranges.index', $test->test_item->id) }}" class="btn btn-primary" ><i class="bi bi-sliders"></i></a>
                                    @else
                                        <a style="cursor: not-allowed;" class="btn btn-secondary" ><i class="bi bi-sliders"></i></a>
                                    @endif
                                </td>
                                <td>
                                    @if(isset($test->test_item->input_type) && $test->test_item->input_type == 'SUMMER_NOTE')
                                        <a href="{{ route('test-item-templates.index', $test->test_item->id) }}" class="btn btn-info" >
                                            <i class="bi bi-file-text"></i>
                                        </a>
                                    @else
                                        <a style="cursor: not-allowed;" class="btn btn-secondary" ><i class="bi bi-file-text"></i></a>
                                    @endif
                                </td>
                                <td class="thbutton">
                                    <div class="form-check form-check-inline{{$i}}">
                                        <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-items.readonly')}}" data-id="{{ isset($test->test_item->id) && $test->test_item->id ? $test->test_item->id : ''}}" data-status="{{isset($test->test_item->is_read_only) && $test->test_item->is_read_only=='0' ? '1' : '0'}}" {{ isset($test->test_item->is_read_only) && $test->test_item->is_read_only=='1' ? 'checked' : ''}}>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-check form-check-inline{{$i}}">
                                        <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-items.changestatus')}}" data-id="{{ isset($test->test_item->id) && $test->test_item->id ? $test->test_item->id : ''}}" data-status="{{ isset($test->test_item->status) && $test->test_item->status=='0' ? '1' : '0'}}" {{ isset($test->test_item->status) && $test->test_item->status=='1' ? 'checked' : ''}}>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-check form-check-inline{{$i}}">
                                        <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-items.changePageBreakstatus')}}" data-id="{{ $test->id }}" data-status="{{ isset($test->page_break) && $test->page_break=='0' ? '1' : '0'}}" {{ isset($test->page_break) && $test->page_break=='1' ? 'checked' : ''}}>
                                    </div>
                                </td>
                                @if(in_array('test-list-edit', $authRolePermissions))
                                <td>
                                    <a href="{{ isset($test->test_item->id) ? route('test-items.edit', $test->test_item->id) : '' }}" class="btn btn-outline-secondary edit_note" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                    </a>
                                </td>
                                @endif
                                @if(in_array('test-list-delete', $authRolePermissions))
                                <td>
                                    <a data-url="{{route('test-package-groups.test-destroy', $group->test_package_id)}}" data-id="{{$test->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip"data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                    </a>
                                </td>
                                @endif
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="9">Records not Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>

            <nav class="row align-items-center mt-3 pb-3">
                @if(in_array('test-list-import', $authRolePermissions))
                  <div class="col-md-12" style="text-align: right;">
                    <div class="btn-group mb-0">
                        <a class="btn btn-outline-primary" href="{!! route('test-items.import-create', $group->id) !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
                    </div>
                  </div>
                @endif
            </nav>
        </div>
        @if(in_array('test-package-group-note-list', $authRolePermissions))
            <div class="col-12 justify-content-center mb-5 radius-5 min-height">
                <div style="" class="accordion-item">
                    <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#test-package-note-collapse{{$key}}" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                        <b>Test Package Group Note</b>
                      </button>
                    </h2>
                    <div style="" id="test-package-note-collapse{{$key}}" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                      <div class="accordion-body">
                        @if (isset($group->test_package_group_notes) && count($group->test_package_group_notes))
                            <table id="" class="table table-bordered align-middle" style="width:100%">
                                @php $sno = 1; @endphp
                                @foreach ($group->test_package_group_notes as $note)
                                    @if(empty($note->id))
                                        @php continue; @endphp
                                    @endif
                                    <tr>
                                        <td style="width: 100%;">{!! $note->group_note !!}</td>
                                        <td class="thbutton">
                                            <div class="form-check form-check-inline{{$i}}">
                                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}"
                                                data-url="{{route('test-package-groups.note_changestatus')}}"
                                                data-id="{{$note->id}}"
                                                data-status="{{$note->status=='0' ? '1' : '0'}}"
                                                {{ $note->status=='1' ? 'checked' : ''}}>
                                            </div>
                                        </td>
                                        <td>
                                            <a href="{{ route('test-package-groups.note-edit', $group->id) }}" title="Group Note" class="btn btn-outline-secondary" ><i class="bi bi-pencil-square"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            </table>
                        @endif
                    </div>
                </div>
            </div>
        @endif

    @endforeach
@else
<div class="card shadow-none radius-5 min-height test_package_groups mt-4">
    <h5 class="text-center"><b><u>Test package group(s) not Found</u></b></h5>
</div>
@endif
@if(in_array('test-package-note-list', $authRolePermissions))
    @if (isset($packages->package_notes) && count($packages->package_notes) > 0)

        <div class="mt-3 col-12 justify-content-center mb-3">
            <div style="" class="accordion-item">
                <h2 class="accordion-header package_note_accordion_header" id="panelsStayOpen-headingTwo">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#test-package-note-collapse" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">

                    <div class="col-11">
                        <b>Test Package Note</b>
                    </div>
                    <div class="package_note_edit_hide" style="display: none">
                        <a href="{{ route('test-package.package-note-edit', $package_id) }}" title="Group Note" class="btn btn-outline-secondary" ><i class="bi bi-pencil-square"></i></a>
                    </div>

                  </button>
                </h2>

                <div style="" id="test-package-note-collapse" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                  <div class="accordion-body">
                    <table id="" class="table table-bordered align-middle" style="width:100%">
                        @foreach ($packages->package_notes as $note)
                            <tr>
                                <td style="width: 100%">{!! $note->package_note !!}</td>
                                <td class="thbutton">
                                    <div class="form-check form-check-inline{{$i}}">
                                        <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}"
                                        data-url="{{route('test-package.package-note_changestatus')}}"
                                        data-id="{{$note->id}}"
                                        data-status="{{$note->status=='0' ? '1' : '0'}}"
                                        {{ $note->status=='1' ? 'checked' : ''}}>
                                    </div>
                                </td>
                                <td>
                                    <a href="{{ route('test-package.package-note-edit', $package_id) }}" title="Group Note" class="btn btn-outline-secondary" ><i class="bi bi-pencil-square"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    @endif
@endif
<script>
    $(document).ready( function () {
        $('#myTable').DataTable({
            "paging":   false,
            "info":     false
        });
    } );
    $(document).on('change input', '.test_package_search', function() {
        var search = $(this).val();

        if (search.length > 1) {
            $('.dataTables_filter').find('input[type="search"]').val(search).trigger('input');
        } else {
            $('.dataTables_filter').find('input[type="search"]').val('').trigger('input');
        }
    });
</script>
