<form class="row g-3 auto-width form update-package" method="post" action="{{ route('test-packages.update', $data->id) }}">
    @csrf
    @method('put')

    <div class="col-md-12">
        <label for="name" class="form-label">Package Name 
            <span class="text-danger"><b>*</b></span>
        </label>
        <input type="text" value="{{ old('name', $data->name) }}" class="form-control name" name="name" aria-describedby="inputGroupPrepend">
        <span class="text-danger error_test_package_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="description" class="form-label">Dept/Profile
            <span class="text-danger"><b>*</b></span>
        </label>
        <select class="single-select department form-control" name="department_id">
            @foreach ($departments as $department)
                <option {{ ($data->department_id == $department->id) ? 'selected' : '' }} value='{{ $department->id }}'>{{ $department->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_department" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="description" class="form-label">Sample Type
            <span class="text-danger"><b>*</b></span>
        </label>
        <select class="single-select sample_type form-control" name="sample_type_id">
            @foreach ($sample_types as $sample_type)
                <option {{ ($data->sample_type_id == $sample_type->id) ? 'selected' : '' }} value='{{ $sample_type->id }}'>{{ $sample_type->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_sample_type" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="validationCustomUsername" class="form-label">Package Short Name</label>
        <input type="text" value="{{ old('short_name', $data->short_name) }}" class="form-control short_name" id="validationCustomUsername" name="short_name" aria-describedby="inputGroupPrepend">
    </div>

    <div class="col-md-6">
        <label for="description" class="form-label">Package Code</label>
        <input type="text" value="{{ old('code', $data->code) }}" class="form-control code" name="code" aria-describedby="inputGroupPrepend">
    </div>

    <div class="col-md-6">
        <label for="report delivery TAT" class="form-label">Report Delivery TAT</label>
        <select class="form-control" name="report_delivery_tat">
            @for($i=1; $i < 31; $i++)
                <option {{ ($data->report_delivery_tat == $i) ? 'selected' : '' }} value="{{ $i }}">{{ $i }}</option>
            @endfor
        </select>
    </div>

    <div class="col-md-6">
        <label for="priority" class="form-label">Priority</label>
        <input type="text" value="{{ old('priority', $data->priority) }}" class="form-control priority" name="priority" aria-describedby="inputGroupPrepend">
    </div>

    <div class="col-md-6">
        <label for="remarks" class="form-label">Remarks
        </label>
        <textarea name="remarks" value="{{ old('remarks') }}" id="remarks" class="form-control remarks" cols="30" rows="2">{{ $data->remarks }}</textarea>
    </div>

    <div class="col-md-6">
        <label for="pre booking required" class="form-label">Pre Booking Required</label><br>
        <input class="form-check-input btn-lg pre_booking_required" {{ ($data->pre_booking_required == 1) ? 'checked' : '' }} name="pre_booking_required" type="checkbox">
    </div>
    
</form>
<script>
    $.switcher('.pre_booking_required');
</script>
