<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
                <th>Test Package Name</th>
                <th>Department Name</th>
		        <!-- <th>Sample Type</th> -->
                <th>Priority</th>
                <th class="thbutton">TAT</th>
                <th class="thbutton">Products</th>
		        <th class="thbutton">Page Break</th>
		        <th class="thbutton">Show In Report</th>
		        <th class="thbutton">Status</th>
                @if(in_array('test-package-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('test-package-delete', $authRolePermissions))
		          <th class="thbutton">Delete</th>
                @endif
		    </tr>
	    </thead>
	    <tbody>
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $package)
				    <tr>
				        <td class="text-center">{{ $data->firstItem() + $key }}</td>
				        <td style="white-space: normal;">
                            <strong>
                            <a class="groups" href="{{ route('test-package-groups.index', $package->id) }}">{{ $package->name }}</a>
                            </strong>
                            <br>
                            <!-- <small>{{ $package->code }}</small> -->
                            {{ $package->short_name }}
                        </td>
                        <td style="white-space: normal;">{{ $package->department }}</td>
                        <!-- <td style="white-space: normal;">{{ $package->sample_type }}</td> -->
				        <td>{{ $package->priority }}</td>
                        <td>{{ $package->report_delivery_tat }}</td>
                        <td style="text-align: center;">
                            <button data-id="{{ $package->id }}" class="btn btn-outline-secondary button-large show_products" data-id="{!! $package->id !!}" data-title="{{ $package->name }}" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bx bx-info-circle"></i> Linked Items
                            </button>
                      </td>
				        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-packages.pagebreak')}}" data-id="{{$package->id}}" data-status="{{$package->is_page_break=='0' ? '1' : '0'}}" {{ $package->is_page_break=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-packages.showreport')}}" data-id="{{$package->id}}" data-status="{{$package->show_in_report=='0' ? '1' : '0'}}" {{ $package->show_in_report=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('test-packages.changestatus')}}" data-id="{{$package->id}}" data-status="{{$package->status=='0' ? '1' : '0'}}" {{ $package->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('test-package-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $package->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('test-package-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('test-packages.destroy')}}" data-id="{{$package->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="left" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="10">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row align-items-center mt-3 gx-2">
    <div class="col-md-7">
        {!! $data->onEachSide(0)->render('test-packages.pagination') !!}
    </div>
    <div class="col-md-3" style="text-align: right;">
        @if(auth()->user()->can('test-package-import'))
            <div class="btn-group mb-0">
                <a class="btn btn-outline-primary" href="{!! route('test-packages.import-create') !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
            </div>
        @endif
    </div>

    <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
            <option value="10" {!! isset($sort_by) && $sort_by == '10' ? 'selected' : '' !!}>Show: 10</option>
            <option value="30" {!! isset($sort_by) && $sort_by == '30' ? 'selected' : '' !!}>Show: 30</option>
            <option value="50" {!! isset($sort_by) && $sort_by == '50' ? 'selected' : '' !!}>Show: 50</option>
        </select>
    </div>
</nav>
</div>
