<form class="row g-3 auto-width" action="{{ route('users.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
    <div class="col-md-12">
        <label class="form-label">Login Email <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" placeholder="Enter Email" name="email" />
        @if ($errors->has('email'))
        <span class="text-danger">{{ $errors->first('email') }}</span>
        @endif
        <span class="text-danger error_email" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label class="form-label">Password <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" placeholder="Enter Password" name="password" />
        @if ($errors->has('password'))
        <span class="text-danger">{{ $errors->first('password') }}</span>
        @endif
        <span class="text-danger error_password" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label class="form-label">Confirm Password <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" placeholder="Enter Confirm Password" name="confirm-password" />
        @if ($errors->has('confirm-password'))
        <span class="text-danger">{{ $errors->first('confirm-password') }}</span>
        @endif
        <span class="text-danger error_confirm" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="validationCustomUsername" class="form-label">Full Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="validationCustomUsername" name="name" aria-describedby="inputGroupPrepend" required placeholder="Enter Full Name">
        @if ($errors->has('name'))
        <span class="text-danger">{{ $errors->first('name') }}</span>
        @endif
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>

    @if(in_array('Admin',auth::user()->roles->pluck('name')->all()))
        <div class="col-md-6">
            <label for="validationCustomUsername" class="form-label">User Type <span class="text-danger"><b>*</b></span></label>
            <select class="form-control" name="user_type">
                @foreach($user_types as $type)
                    <option value="{{ $type->code }}">
                        {{ ucfirst($type->name) }}
                    </option>
                @endforeach
            </select>
            @if ($errors->has('name'))
            <span class="text-danger">{{ $errors->first('name') }}</span>
            @endif
            <span class="text-danger error_name" style="display: none;">This field is required.</span>
        </div>
    @endif

    <div class="col-md-6" style="display: none;">
        <label for="validationCustomUsername" class="form-label">User ID <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="validationCustomUsername" name="username" aria-describedby="inputGroupPrepend" required placeholder="Enter User ID">
        @if ($errors->has('username'))
        <span class="text-danger">{{ $errors->first('username') }}</span>
        @endif
        <span class="text-danger error_username" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6" id="test_items">
        <label for="validationTextarea" class="form-label">Role <span class="text-danger"><b>*</b></span></label>
        <select class="multi-select-tests" multiple name="roles[]" required>
            @foreach($roles as $list)
            <option>{{ $list }}</option>
            @endforeach
        </select>
        <span class="text-danger error_roles" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label class="form-label">Prepared By <span class="text-danger"><b>*</b></span></label>
       <input type="text" name="prepared_by" class="form-control" placeholder="Enter Prepared by" >
        </select>
        @if ($errors->has('prepared_by'))
        <span class="text-danger">{{ $errors->first('prepared_by') }}</span>
        @endif
        <span class="text-danger error_prepared_by" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="validationCustom01" class="form-label">Company Name <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" name="company_id" required>
            @foreach($company as $list)
            <option value="{{ $list->id }}">{{ $list->name }}</option>
            @endforeach
        </select>
        @if ($errors->has('company_id'))
        <span class="text-danger">{{ $errors->first('company_id') }}</span>
        @endif
    </div>
    <div class="col-md-6">
        <label class="form-label">User Designation <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="user_designation" class="form-control" placeholder="Enter Designation" >
        </select>
        @if ($errors->has('user_designation'))
        <span class="text-danger">{{ $errors->first('user_designation') }}</span>
        @endif
        <span class="text-danger error_user_designation" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6 phone_no_col">
        <label class="form-label">Phone no<span class="text-danger"><b>*</b></span></label>
        <input type="tel" class="form-control" placeholder="" id="phone_no" value="{!! old('phone_no') !!}" />
        <input type="hidden" name="phone_no">

        @if ($errors->has('phone_no'))
        <span class="text-danger">{{ $errors->first('phone_no') }}</span>
        @endif
        <span class="text-danger error_phone" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6 whatsapp_no_col">
        <label class="form-label">Whatsapp no </label>
        <input type="tel" class="form-control" placeholder="" id="whatsapp_no" value="{!! old('whatsapp_no') !!}"/>
        <input type="hidden" name="whatsapp_no">
        @if ($errors->has('whatsapp_no'))
        <span class="text-danger">{{ $errors->first('whatsapp_no') }}</span>
        @endif
    </div>

    <div class="col-md-6">
        <label for="validationTextarea" class="form-label">User Profile</label>
        <input type="file" class="form-control" name="user_image" aria-label="file example">
        <div class="invalid-feedback">Example invalid form file </div>
    </div>
    <div class="col-md-6">
        <label for="validationTextarea" class="form-label">Signature Image</label>
        <input type="file" class="form-control" name="user_signature" aria-label="file example">
        <div class="invalid-feedback">Example invalid form file </div>
    </div>
    {{-- <div class="col-md-6">
        <div>
            <label for="account_id" class="form-label">Account <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="form-control" name="account_id">
                @foreach($account as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_account_id" style="display: none;">This field is required.</span>
    </div> --}}
     <!-- Account-->
     <div class="col-md-12">
        <div>
            <label class="form-label">Account </label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="account_id" class="account-select form-control" placeholder="Search Account">
            <ul class="searchResult"></ul>
            <input type="hidden" name="account_id" value="">
        </div>
        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
    </div>
</form>

<script type="text/javascript">
    $('.multi-select-tests').select2({
        theme: 'bootstrap4',
        dropdownParent: $("#test_items"),
        placeholder: "Select Role",
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        allowClear: Boolean($(this).data('allow-clear')),
    });
</script>

