@extends('layouts.app')
@section('title', 'Edit Document')
@section('pages')
<style type="text/css">
    
    .intl-tel-input {
        width: 100%;
    }
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Document</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="{{ route('vehicle-document-types.index') }}">Document List</a></li>
                <li class="breadcrumb-item active" aria-current="page">Edit Document</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{ route('vehicle-document-types.index') }}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('vehicle-document-types.update', $vehicle_document_type->id) }}" method="post" enctype='multipart/form-data' id="account_form">
                        @csrf
                        @method('PUT')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Document Type</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <div>
                                            <label for="name" class="form-label">Document Type</label>
                                            <input type="text" class="form-control" id="name" name="name" value="{{ $vehicle_document_type->name }}" placeholder="Document Type" aria-describedby="inputGroupPrepend">
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="code" class="form-label">Document Code</label>
                                            <input type="text" class="form-control" id="code" name="code" value="{{ $vehicle_document_type->code}}" placeholder="Document Code" aria-describedby="inputGroupPrepend"> 
                                            <input type="hidden" class="form-control" id="status" name="status" value="{{ $vehicle_document_type->status}}" aria-describedby="inputGroupPrepend">
                                        </div>
                                     </div>
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                    <!-- Additional fields if needed -->
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            <button class="btn btn-primary save_vehicle" id="save_vehicle" type="submit"><i class="bx bx-save"></i> Save Document Type</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <div class="col-md-7"><h5 class="mb-0">More Details</h5></div>
                                    <hr class="mb-0">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->
@endsection


@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script src="{!! asset('admin/js/accounts.js') !!}"></script>


<script>
    $(document).on('click', '#bodyVitals', function(){
        if ($('#bodyVitals').hasClass('hiddenVitals')) {
            $('.body_vitals_details').show();
            $('#bodyVitals').html('<i class="bx bx-minus"></i> Hide Vitals');
            $('#bodyVitals').removeClass('hiddenVitals');
        } else {
            $('.body_vitals_details').hide();
            $('#bodyVitals').html('<i class="bx bx-plus"></i> Add Vitals');
            $('#bodyVitals').addClass('hiddenVitals');
        }
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }
    $("#ipd_file_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#ipd_file_no").val(onlyNumbers);
    });
    $(document).on('click','.save_button', function(e) {
        e.preventDefault();
        if ($('#commonModal').find('form').hasClass('create_driver')) {

            $('.error_name').hide();
            $('.error_email').hide();
            $('.error_phone').hide();
            $('.error_country_id').hide();
            var error = 0;
            if ($('#phone_no').val().trim() != '') {
                var dailcode_title = $('.phone_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="phone_no"]').val("+" + dailcode_array[1] + $('#phone_no').val());
            }
            $('#year').trigger("change")
            
            if ($('#whatsapp_no').val().trim() != '') {
                var dailcode_title = $('.whatsapp_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="whatsapp_no"]').val("+" + dailcode_array[1] + $('#whatsapp_no').val());
            }

            if ($('input[name="name"]').val().trim() == '') {
              $('.error_name').show();
              error = 1;
              setTimeout(function () {
                $('.error_name').hide();
                }, 3000);
            }
            if ($('[name="country_id"]').val().trim() == '') {
              $('.error_country_id').show();
              error = 1;
            }
            if ($('input[name="phone_no"]').val().trim() == '') {
              $('.error_phone').show();
              error = 1;
              setTimeout(function () {
                    $('.error_name').hide();
                }, 3000);
            }
            

            if (error == 0) {
                let formdata = new FormData($('#create_driver_form')[0]);

                $.ajax({
                    url: $('#create_driver_form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            $('[name="driver_ac_id"]').val(response.data.id);
                            $('#driver_ac_id').val(response.data.name);
                            $('#edit_driver').prop('disabled', false);
                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
            }
        }
        else if ($('#commonModal').find('form').hasClass('update_driver')) {
            console.log('as');
            if ($('#phone_no').val().trim() != '') {
                var dailcode_title = $('.phone_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="phone_no"]').val("+" + dailcode_array[1] + $('#phone_no').val());
            }
            
            if ($('#whatsapp_no').val().trim() != '') {
                var dailcode_title = $('.whatsapp_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="whatsapp_no"]').val("+" + dailcode_array[1] + $('#whatsapp_no').val());
            }

            $('.error_name').hide();
            $('.error_email').hide();
            $('.error_phone').hide();
            $('.error_country_id').hide();
            var error = 0;

            if ($('input[name="name"]').val().trim() == '' || $('[name="account_title_id"]').val() == '') {
              $('.error_name').show();
              error = 1;
              setTimeout(function () {
                $('.error_name').hide();
                }, 3000);

            }

            if ($('[name="country_id"]').val().trim() == '') {
              $('.error_country_id').show();
              error = 1;
              setTimeout(function () {
                $('.error_country_id').hide();
                }, 3000);

            }

            if ($('input[name="phone_no"]').val().trim() == '') {
              $('.error_phone').show();
              error = 1;
              setTimeout(function () {
                $('.error_phone').hide();
                }, 3000);

            }

            if (error == 0) {
                let formdata = new FormData($('#update_driver_form')[0]);

                $.ajax({
                    url: $('#update_driver_form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            $('[name="driver_ac_id"]').val(response.data.id);
                            $('#driver_name').val(response.data.name);

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
            }
        }
        else if ($('#commonModal').find('form').hasClass('create_vendor')) {
            if ($('#phone_no').val().trim() != '') {
                var dailcode_title = $('.phone_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="phone_no"]').val("+" + dailcode_array[1] + $('#phone_no').val());
            }

            $('.error_name').hide();
            $('.error_email').hide();
            $('.error_country_id').hide();
            var error = 0;

            if ($('input[name="name"]').val().trim() == '') {
              $('.error_name').show();
              error = 1;
            }
            if ($('[name="country_id"]').val().trim() == '') {
              $('.error_country_id').show();
              error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#create_vendor_form')[0]);

                $.ajax({
                    url: $('#create_vendor_form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            $('[name="vendor_ac_id"]').val(response.data.id);
                            $('#vendor_ac_id').val(response.data.name);
                            $('#edit_vendor').prop('disabled', false);
                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
            }
        }
        else if ($('#commonModal').find('form').hasClass('create_cities')) {
            console.log('tset');
            event.preventDefault();
            $('.error_name').hide();
            var error = 0;
            setTimeout(function() {
                $('.error_name').hide();
            }, 3000);


            if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
                $('.error_name').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({
                    url: $('#commonModal').find('form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');

                            // var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                            // var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                            // var sort_type = $('#hidden_sort_type').val();
                            // var query = $('#search').val() ? $('#search').val() : '';

                            // fetch_data(page, sort_type, column_name, query);

                            // hide modal
                            $('#commonModal').removeClass('create_cities');
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                            setTimeout(function() {
                                $('#create_driver').trigger('click');
                                CitySelected(response.data.id);
                            }, 1000);

                    } else {
                        toastr.error(response.message, 'Error!');
                    }
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.log('AJAX request failed:', textStatus, errorThrown);
                toastr.error('An error occurred during the request.', 'Error!');

                // hide modal
                $('#commonModal').modal('hide');
                $('#commonModal').find('.modal-body').html('');
            });
            }
            error = 1;
        }
        else if ($('#commonModal').find('form').hasClass('update_vendor_details')) {
            console.log('as');
            if ($('#phone_no').val() != '') {
                var dailcode_title = $('.phone_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="phone_no"]').val("+" + dailcode_array[1] + $('#phone_no').val());
            }

            $('.error_name').hide();
            var error = 0;

            if ($('input[name="name"]').val() == '' || $('[name="account_title_id"]').val() == '') {
              $('.error_name').show();
              error = 1;
              setTimeout(function () {
                $('.error_name').hide();
                }, 3000);

            }



            if (error == 0) {
                let formdata = new FormData($('#update_vendor_form')[0]);

                $.ajax({
                    url: $('#update_vendor_form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            $('[name="vendor_ac_id"]').val(response.data.id);
                            $('#vendor_ac_id').val(response.data.name);

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
            }
        }
        else {
            $('.error_driver_ac_id').hide();
            $('.error_vendor_ac_id').hide();
            $('.error_admission_date').hide();
            $('.error_ipd_file_no').hide();

            var error = 0;

            if ($('input[name="driver_ac_id"]').val().trim() == '') {
              $('.error_driver_ac_id').show();
              error = 1;
              setTimeout(function () {
                $('.error_driver_ac_id').hide();
                }, 3000);

            }
            if ($('input[name="vendor_ac_id"]').val() == '') {
              $('.error_vendor_ac_id').show();
              error = 1;
              setTimeout(function () {
                $('.error_vendor_ac_id').hide();
                }, 3000);

            }
           
           
        }

        error = 1;
    })

    function reinitializeTelInput(countryCode) {
        var telInput = $('#commonModal').find('#phone_no , #whatsapp_no , #alternative_no');
        telInput.intlTelInput('destroy'); // Destroy the existing instances

        telInput.intlTelInput({
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
            initialCountry: countryCode || '{!! $countryCode ?? '' !!}',
            separateDialCode: true
        });
    }

    $(document).ready(function(){



        $('.driver-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="driver_ac_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('register-search-driver') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_drivers_for_billing',
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="driver_ac_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                                code: item.code,
                                phone_no: item.phone_no,
                                date_of_birth: item.date_of_birth,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

                $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + phone_no + "");
                $('[name="driver_ac_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')' + phone_no + "</a>")
                .appendTo(ul);
        };

        

        //vendor select
        $('.vendor-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="vendor_ac_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('register-search-vendor') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_vendors_for_billing',
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="vendor_ac_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                                code: item.code,
                                phone_no: item.phone_no,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

                $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + phone_no + "");
                $('[name="vendor_ac_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')'  + phone_no + "</a>")
                .appendTo(ul);
        };
    });

    const driverSelect = document.querySelector(".driver-select");
    const vendorSelect  = document.querySelector(".vendor-select");
    const querySelector = document.querySelector(".searchResult");

    document.addEventListener("click", (event) => {
        if (event.target !== driverSelect && event.target !== vendorSelect && event.target !== querySelector) {
            $(".searchResult").empty();
        }
    });

    /**************** create driver ********************/
    $(document).on('click', '#create_driver', function(){
        $('#commonModalLabel').text('Add New Driver');
        $('.save_button_span').text('Save Driver');
        $.ajax({
          url:"{!! route('driver-account-create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            reinitializeTelInput();
          }
        })
    })
    /**************** create vendor ********************/
    $(document).on('click', '#create_vendor', function(){
        $('#commonModalLabel').text('Add New vendor');
        $('.save_button_span').text('Save vendor');
        $.ajax({
          url:"{!! route('vendor-account-create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            reinitializeTelInput();
          }
        })
    })

    /************* edit vendor *************/
     $(document).on('click', '#edit_vendor', function() {
        var customerName = $('[name="vendor_ac_id"]').val();

        if (customerName.trim() === "") {
            $('.error_vendor_ac_id').show();
        } else {
            $('.error_vendor_ac_id').hide();

            $('#commonModalLabel').text('Edit Vendor');
            $('.save_button_span').text('Update Vendor');
            var id = $('[name="vendor_ac_id"]').val();

            var url = `{!! route('vendor-account-edit', ':id') !!}`.replace(':id', id);

            $.ajax({
                url: url,
                success: function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        }
    });

    function CitySelected(id) {
        if ($('[name="city_id"]').length > 0) {
            $('[name="city_id"]').val(id);
        } else {
            setTimeout(function() {
                CitySelected(id);
            }, 1000);
        }
    }

     /**************** Create City ********************/
     $(document).on('click', '#create_city', function() {
        $('#commonModalLabel').text('Add New City');
        $('.save_button_span').text('Save City');
        $.ajax({
            url: "{!! route('cities.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })



    /*********delete data**********/
    $("body").on("click",'.deleteDataCustom', function(event){
          dataString   = {"id":$(this).data('id')};
          var UrlValue = $(this).data('url');
          var btn      = $(this);

          Swal.fire({
              title: 'Are you sure you want to delete this?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              /* Read more about isConfirmed, isDenied below */
              if (result.isConfirmed) {
                  $.ajax({
                  url     : UrlValue,
                  method  : 'post',
                  data    : {
                        "_token": $('meta[name="csrf-token"]').attr('content'),
                        "id": $(this).data('driver_ac_id')
                    },
                  headers:
                  {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  beforeSend: function( xhr ) {
                      // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                  },
                  success : function(response){
                      if(response.success){
                          var ErroMsg = $(this).printErrorMsg(response.message);

                          $(this).Toastshow('success',ErroMsg);
                          fetch_cart();
                      }else{
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error',ErroMsg);
                      }
                  },
                  error: function (data) {
                    console.log("error ",data);
                  }
              });
              }
          });
    });


    /******* Disabling & Enabling edit button of driver ************/
    $(document).ready(function() {
        function toggleEditButton() {
            var driverId = $('[name="driver_ac_id"]').val();
            $('#edit_driver').prop('disabled', driverId.trim() === "");
        }

        toggleEditButton();

        $('#driver_name').on('input', function() {
            toggleEditButton();
        });

        $('#driver_name').on('change', function() {
            toggleEditButton();
        });

        $('#edit_driver').on('click', function() {
            var driverName = $('#driver_ac_id').val().trim();
            if (driverName === "") {
                $('.error_driver_ac_id').show();
            } else {
                $('.error_driver_ac_id').hide();

                $('#commonModalLabel').text('Edit Driver');
                $('.save_button_span').text('Update Driver');
                var id = $('[name="driver_ac_id"]').val();
                var url = `{!! route('driver-account-edit', ':id') !!}`.replace(':id', id);

                $.ajax({
                    url: url,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);
                    }
                });
            }
        });

        function enableEditButton() {
            $('#edit_driver').prop('disabled', false);
        }

        function addValueTodriverId(newValue) {
            $('[name="driver_name"]').val(newValue);
            enableEditButton();
        }
    });

    /******* Disabling & Enabling edit button of vendor ************/
    $(document).ready(function() {
        function toggleEditButton() {
            var vendorId = $('[name="vendor_ac_id"]').val();
            $('#edit_vendor').prop('disabled', vendorId.trim() === "");
        }

        toggleEditButton();

        $('#vendor_ac_id').on('input', function() {
            toggleEditButton();
        });

        $('#vendor_ac_id').on('change', function() {
            toggleEditButton();
        });

        $('#edit_vendor').on('click', function() {
            var vendorName = $('#vendor_ac_id').val().trim();

            if (vendorName === "") {
                $('.error_vendor_ac_id').show();
            } else {
                $('.error_vendor_ac_id').hide();

                $('#commonModalLabel').text('Edit Vendor');
                $('.save_button_span').text('Update Vendor');
                var id = $('[name="vendor_ac_id"]').val();
                var url = `{!! route('vendor-account-edit', ':id') !!}`.replace(':id', id);

                $.ajax({
                    url: url,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);
                    }
                });
            }
        });

        function enableEditButton() {
            $('#edit_vendor').prop('disabled', false);
        }

        function addValueTovendorId(newValue) {
            $('[name="vendor_ac_id"]').val(newValue);
            enableEditButton();
        }
    });

</script>
@endsection
