<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No.</th>
                <th>Document Name</th>
                <th>Document No.</th>
                <th>Registration/Renewal Date</th>
                <th>Expiry Date</th>
                <th class="text-center">Is Received</th>
                <th class="thbutton">Edit</th>
                <th class="thbutton">Delete</th>
            </tr>
        </thead>
        <tbody>
        @php $i = 1; @endphp
        @forelse($vehicleDocuments as $list)
            <tr>
                <td class="text-left">{{ $i++ }}</td>
                <td class="text-left">
                    {{ $list->document_type_name }} 
                    <input type="hidden" name="vehicle_id" value="{{ $list->vehicle_id }}"> 
                    <input type="hidden" name="document_id" value="{{ $list->document_type_id }}">
                </td>
                <td>{{ $list->document_no }}</td>
                <td>{{ $list->renewal_date }}</td>
                <td>{{ $list->last_renewal_date }}</td>
                <td class="text-center">
                    <div class="form-check form-check-inline{{$i}}">
                        <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{ route('vehicle-document-validity-changestatus') }}" data-id="{{ $list->vehicle_document_validity_id }}" data-status="{{ $list->is_received == '0' ? '1' : '0' }}" {{ $list->is_received == '1' ? 'checked' : '' }}>
                    </div>
                </td>
                <td class="thbutton">
                    <a data-id="{{ $list->id }}" class="btn btn-warning edit edit_vehicle_document_validity_btn" type="button" data-bs-toggle="modal" data-bs-target="#commonModal" id="edit_vehicle_document_validity_btn">
                        <i class="bi bi-pencil-square text-white"></i>
                    </a>
                </td>
                <td class="thbutton">
                    <a 
                        data-url="{{ route('vehicle-document-validity.destroy' , $list->id) }}"  class="btn btn-danger deleteDataCustom" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                        <i class="bi bi-trash text-white"></i>
                    </a>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="7">No Data Found</td>
            </tr>
        @endforelse
        </tbody>
    </table>
</div>

<nav class="mt-2 row d-flex align-items-center">
    <div class="col-md-6">
        {!! $vehicleDocuments->onEachSide(0)->render('vehicle-document-validity.import-pagination') !!}
    </div>
    <div class="col-lg-6 col-md-12 col-12 d-flex justify-content-end align-items-center">
        <div class="d-flex align-items-center">
            <select class="form-select sorting sorting-box" id="example_length" name="example_length" aria-controls="example">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
        </div>
    </div>
</nav>
