<form class="row g-3 auto-width voucher_series" action="{{ route('voucher-series.store')}}" method="post" enctype='multipart/form-data' id="type_form">
    @csrf
    <div class="col-md-12">
        <label for="series_name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="series_name" name="series_name" aria-describedby="inputGroupPrepend" required placeholder="Name">
        <span class="text-danger error_series_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="prefix" class="form-label">Prefix</label>
        <input type="text" class="form-control" id="prefix" name="prefix" aria-describedby="inputGroupPrepend" required placeholder="PREFIX">
    </div>
    <div class="col-md-4">
        <label for="separator" class="form-label">Separator</label>
        <input type="text" class="form-control" id="separator" name="separator" aria-describedby="inputGroupPrepend" required placeholder="Separator">
        <span class="text-danger error_separator" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="postfix" class="form-label">Postfix</label>
        <input type="text" class="form-control" id="postfix" name="postfix" aria-describedby="inputGroupPrepend" required placeholder="POSTFIX">
    </div>
    <div class="col-md-6">
        <label for="start_from" class="form-label">Start From</label>
        <input type="number" class="form-control" id="start_from" value="0" name="start_from" aria-describedby="inputGroupPrepend" required placeholder="00001">
    </div>
    <div class="col-md-6">
        <label for="length" class="form-label">Max Length <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" id="length" name="length" aria-describedby="inputGroupPrepend" required placeholder="5" value="5">
        <span class="text-danger error_length" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="frequency" class="form-label">Select Frequency <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" id="frequency" name="frequency" required>
            <option value="Start From Zero (0) Every Year">Start From Zero (0) Every Year</option>
            <option value="Follow Last Year">Follow Last Year</option>
        </select>
        <span class="text-danger error_frequency" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="frequency" class="form-label">Select Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" id="type" required>
            <option value="master">Voucher Master</option>
            <option value="type" selected>Voucher Type</option>
        </select>
        <span class="text-danger error_frequency" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="voucher_type_id" class="form-label">Select Voucher Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="form-select" id="voucher_type_id" name="voucher_type_id" required>
                <option value=""> -- Select Voucher Type -- </option>
                @foreach ($voucher_types as $key => $list)
                    <option value="{!! $list->id !!}">{!! $list->name !!}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_voucher_type" type="button"> + </button>
            </div>
        </div>
        <span class="text-danger error_voucher_type_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12" style="display: none;">
        <div>
            <label for="voucher_master_id" class="form-label">Select Voucher Master <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="form-select" id="voucher_master_id" name="voucher_master_id" required>
                <option value=""> -- Select Voucher Master -- </option>
                @foreach ($voucher_masters as $key => $list)
                    <option value="{!! $list->id !!}">{!! $list->voucher_name !!}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_voucher_master" type="button"> + </button>
            </div>
        </div>
        <span class="text-danger error_voucher_master_id" style="display: none;">This field is required.</span>
    </div>
</form>