<form class="row g-3 auto-width voucher_type" action="{{ route('voucher-types.update', $voucher_type->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="voucher_name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required value="{{$voucher_type->name}}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="voucher_code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required value="{{$voucher_type->code}}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="voucher_title" class="form-label">Voucher Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="voucher_title" name="voucher_title" aria-describedby="inputGroupPrepend" required placeholder="Voucher Title" value="{{$voucher_type->voucher_title}}">
        <span class="text-danger error_voucher_title" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="page_title" class="form-label">Page Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="page_title" name="page_title" aria-describedby="inputGroupPrepend" required placeholder="Voucher Title" value="{{$voucher_type->page_title}}">
        <span class="text-danger error_page_title" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="default_price_type" class="form-label">Default Price Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control select2" name="default_price_type">
            <option value="MRP" {!! $voucher_type->default_price_type=='MRP'?'selected':'' !!}>MRP</option>
            <option value="Purchase Price" {!! $voucher_type->default_price_type=='Purchase Price'?'selected':'' !!}>Purchase Price</option>
            <option value="WholeSale Price" {!! $voucher_type->default_price_type=='WholeSale Price'?'selected':'' !!}>WholeSale Price</option>
            <option value="Discounted/Sale Price(DP)" {!! $voucher_type->default_price_type=='Discounted/Sale Price(DP)'?'selected':'' !!}>Discounted/Sale Price(DP)</option>
            <option value="Min. Sale Price" {!! $voucher_type->default_price_type=='Min. Sale Price'?'selected':'' !!}>Min. Sale Price</option>
            <option value="Manufacturing Cost" {!! $voucher_type->default_price_type=='Manufacturing Cost'?'selected':'' !!}>Manufacturing Cost</option>
        </select>
        <span class="text-danger error_default_price_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend" required value="{{$voucher_type->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    {{-- <div class="col-md-12">
        <label for="voucher_master_id" class="form-label">Select Voucher Master</label>
        <select class="single-select form-control" id="voucher_master_id" name="voucher_master_id" required>
            <option value=""> -- Select Voucher Master -- </option>
            @foreach ($voucher_masters as $key => $list)
                <option value="{!! $list->id !!}" {!! matchSelected($list->id, $voucher_type->voucher_master_id) !!}>{!! $list->voucher_name !!}</option>
            @endforeach
        </select>
        <span class="text-danger error_voucher_master_id" style="display: none;">This field is required.</span>
    </div> --}}
    <input type="hidden" name="voucher_master_id">
</form>