<form class="g-3 row auto-width" action="{{route('blogs.store')}}" method="POST" enctype='multipart/form-data'>
  <!-- For validation comment on -->
  @csrf
  <div class="col-md-12 col-sm-12">

    <div class="g-3 row">
      <div class="col-md-12">
        <label>Blog Title <span class="text-danger">*</span></label>
        <input type="text" class="form-control" placeholder="Blog Title" aria-label="title" name="title">
      </div>
        <div class="col-md-12">
            <label for="validationCustomOrder" class="form-label">Blog Category</label>
            <select class="single-select form-control" id="category_id" name="category_id" required>
                <!-- <option value=""> -- Blog Category -- </option> -->
                @foreach ($categories as $key => $category)
                <option value="{!! $category->id !!}">{!! $category->name !!}</option>
                @endforeach
            </select>
            @if ($errors->has('category_id'))
            <span class="text-danger">{{ $errors->first('category_id') }}</span>
            @endif
            <span class="text-danger error_name" style="display: none;">This field is required.</span>
        </div>
      <div class="col-md-12">
        <label>Image <span class="text-danger">*</span></label>
        <input type="file" class="form-control" placeholder="icon" aria-label="icon" name="image">
      </div>
      <div class="col-md-12">
        <label>Blog Description</label>
        <textarea class="form-textarea" placeholder="description" name="description"  id="description"></textarea>
      </div>
      <div class="col-md-12 tagsP">
        <label for="tags" class="form-label">Tags </label>
        <div class="input-group">
            <select class="multi-select-tags" multiple name="tags[]" required>
                @foreach($tags as $tag)
                <option>{!! $tag->title !!}</option>
                @endforeach
            </select>
        </div>
        @if ($errors->has('tags'))
            <span class="text-danger">{{ $errors->first('tags') }}</span>
        @endif
        <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
    </div>
    </div>
  </div>
</form>
