@extends('layouts.app')
@section('title','Edit Site Visit')
@section('pages')
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Site Visit</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Edit Site Visit</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('home-collections.update',$homeCollection->id)}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Site Visit</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Name <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="name" aria-label="name" name="name" value="{{$homeCollection->name}}">
                    </div>
                    <div class="col-md-12">
                      <label>Phone</label>
                      <input type="number" class="form-control" placeholder="phone" aria-label="phone" name="phone" value="{{$homeCollection->phone}}">
                    </div>
                    <div class="col-md-12">
                      <label>Email</label>
                      <input type="email" class="form-control" placeholder="email" aria-label="email" name="email" value="{{$homeCollection->email}}">
                    </div>
                    <div class="col-md-12">
                      <label>City</label>
                      <input type="text" class="form-control" placeholder="City" aria-label="address" name="city" value="{{$homeCollection->city}}">
                    </div>
                    <div class="col-12" align="center">
                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Update Site Visit</button>
                  </div>
                    </div>
                </div>
              </div>
            </div>
            </div>

            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Site Visit Adittional</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Date <span class="text-danger">*</span></label>
                      <input type="date" class="form-control" placeholder="name" aria-label="name" name="vdate" value="{{date('Y-m-d',strtotime($homeCollection->vdate))}}">
                    </div>
                    {{--<div class="col-md-12">
                      <label>Message</label>
                      <textarea class="form-textarea" placeholder="message" aria-label="phone" name="message" rows="7">{{$homeCollection->message}}</textarea>
                    </div>--}}
                    <div class="col-md-12">
                      <label>Collection Status</label>
                      <select class="single-select" name="collection_status">
                        <option value="Pending" @if($homeCollection->collection_status=='Pending'){{'selected'}}@endif>Pending</option>
                        <option value="Rejected" @if($homeCollection->collection_status=='Rejected'){{'selected'}}@endif>Rejected</option>
                        <option value="Accepted" @if($homeCollection->collection_status=='Accepted'){{'selected'}}@endif>Accept</option>
                      </select>
                    </div>
                </div>
              </div>
            </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection