@extends('layouts.app')
@section('title','Site Visit')
@section('pages')
<!--breadcrumb-->
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Site Visit</div>
  <div class="ms-auto">
    <div class="btn-group">
    </div>
      <div class="btn-group">
          <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
      </div>
  </div>
</div>
<!--end breadcrumb-->

<div class="card shadow-none radius-5 min-height">
  <div class="card-header py-3">
    <div class="row g-3">
      <div class="col-lg-3 col-md-6 me-auto">
        <div class="ms-auto position-relative">
          <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
          <input class="form-control ps-5" type="search" id="search" placeholder="Search Name">
        </div>
      </div>
      <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length" >
        <input class="datepickerss form-control" placeholder="from Date" name="from_date" id="from_date">
      </div>
      <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length" >
        <div class="input-group mb-3">
          <input class="datepickerss form-control" placeholder="To Date" name="to_date" id="to_date">
          <div class="input-group-append">
            <button class="btn btn-outline-secondary DateFilter" type="button"><i class="bi bi-search"></i></button>
          </div>
        </div>
      </div>
      <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length" >
        <div class="input-group mb-3">
          <div class="input-group-append">
            <button class="btn btn-outline-success DateDownload" type="button"><i class="bi bi-download"></i> Download</button>
          </div>
        </div>
      </div>
      <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length">
        <select class="form-select sorting" id="" name="example_length" aria-controls="example">
          <option value="10">Show: 10</option>
          <option value="30">Show: 30</option>
          <option value="50">Show: 50</option>
        </select>
      </div>
    </div>
  </div>

  @include('website-setting.HomeCollections.table')

  <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
  <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
  <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
</div>

<script>
  $(document).ready(function() {
    function clear_icon() {
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }

    function fetch_data(page, sort_type, sort_by, query,todate=null) {
      $.ajax({
        url: "?page=" + page + "&sortby=" + sort_by + "&sorttype=" + sort_type + "&query=" + query+"&todate="+todate,
        success: function(data) {
          $('#tables').html('');
          $('#tables').html(data);
          $(document).ready(function() {
            $.switcher();
          });
        }
      })
    }
    $('body').on('click', '.DateFilter', function() {
      var query         = $('#from_date').val();
      var column_name   = $('.sorting').val();
      var sort_type     = 'datefilter';
      var todate        = $('#to_date').val();
      var page          = 1 ? 1 : (this).attr('href').split('page=')[1];
      fetch_data(page, sort_type, column_name, query,todate);
    });

    $('body').on('click', '.DateDownload', function() {
      var from_date=$('#from_date').val();
      var to_date=$('#to_date').val();
      window.location.href="{{ route('export-visit-request') }}?from_date="+from_date+"&&to_date="+to_date; 
    });

    $('body').on('keyup', '#search', function() {
      var query         = $('#search').val();
      var column_name   = $('.sorting').val();
      var sort_type     = $('#hidden_sort_type').val();
      var page          = 1 ? 1 : (this).attr('href').split('page=')[1];
      fetch_data(page, sort_type, column_name, query);
    });
    $('body').on('change', '.sorting', function() {

      var column_name       = $(this).val();
      var order_type        = $(this).data('sorting_type');
      var reverse_order     = '';
      var page              = 1 ? 1 : (this).attr('href').split('page=')[1];
      var query = $('#search').val() ? $('#search').val() : '';
      fetch_data(page, reverse_order, column_name, query);
    });
    $('body').on('click', '.pager a', function(event) {
      event.preventDefault();
      
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name       = $('.sorting').val() ? $('.sorting').val() : '';
      var sort_type         = $('#hidden_sort_type').val();
      var query             = $('#search').val() ? $('#search').val() : '';
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query);
    });
    $("body").on("click",'.addgallery', function(event){
      var id=$(this).data('id');
        $('#mid').val(id);
        $('#exampleModal').modal('toggle');
    }
    )
  });

</script>



@endsection