@extends('layouts.app')
@section('title','Edit Plan')
@section('pages')
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Plan</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Edit Plan</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('package-plans.update',$Plan->id)}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Plans Details</h5>
                    <div class="col-md-12">
                      <label>Plan Name <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Plan name" aria-label="title" name="title" value="{{$Plan->title}}">
                    </div>
                    <div class="col-md-12">
                      <label>Plan Price <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Plan Price" aria-label="price" name="price" value="{{$Plan->price}}">
                    </div>
                    
                    <div class="d-grid gap-2">
                      <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Update Plan</button>
                    </div>
                </div>
              </div>
            </div>
            </div>

            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Additional Info</h5>
                   
                    <div class="col-md-12">
                      <label>Test <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Test" aria-label="test" name="test" value="{{$Plan->test}}">
                    </div>
                    <div class="col-md-12">
                      <label>Plan Details</label>
                      <textarea class="form-textarea" placeholder="description" aria-label="description" name="description" rows="4">{{$Plan->description}}</textarea>
                    </div>
                </div>
              </div>
            </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection