@extends('layouts.app')
@section('title','Public Content')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Content</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add Content</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
      @php
        $redirect = request()->redirect ?? '';
        if(isset($redirect) && $redirect!='')
        {
          $redirectUrl = route($redirect.'.show',request()->subcategory_id).'?category_id='.request()->category_id;
        }
        else
        {
          $redirectUrl = route('public-content.index');
        }

      @endphp
        <div class="btn-group">
            <a href="{{$redirectUrl}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('public-content.store')}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Content Details</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <input type="hidden" name="redirect" value="{!! request('redirect') ?? '' !!}">
                      <label>Category Name<span class="text-danger">*</span></label>
                      <select class="form-control" name="public_content_category_id" id="category_id" onchange="getsubcategory()">
                        <option value=" ">--Select Category--</option>
                        @foreach($category as $cate)
                        <option value="{{$cate->id}}" {!! isset(request()->category_id) && request()->category_id==$cate->id ? 'selected': '' !!}>{{$cate->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-12">
                      <label>Sub Category Name<span class="text-danger">*</span></label>
                      <select class="form-control" name="sub_category_id" id="sub_category_id">
                        <option value=" ">--Select Sub Category--</option>
                      </select>
                    </div>
                    <div class="col-md-12">
                      <label>Title<span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Title" aria-label="title" name="title">
                    </div>
                    <div class="col-md-12">
                      <label>link</label>
                      <input type="text" class="form-control" placeholder="Link" aria-label="link" name="link">
                    </div>


                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Save Public Content Data</button>
                  </div>
                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Content Info</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Image Files </label>
                      <input type="file" class="form-control" placeholder="" aria-label="files" name="images" accept="image/*">
                    </div>
                    <div class="col-md-12">
                      <label>Pdf Files </label>
                      <input type="file" class="form-control" placeholder="" aria-label="files" name="pdf_file" accept=".pdf">
                    </div>
                    <div class="col-md-12">
                      <label>Prority</label>
                      <input type="text" class="form-control" placeholder="Prority" aria-label="priority_status" name="priority_status">
                    </div>
                    <div class="col-md-12">
                      <label>Description</label>
                      <textarea class="form-textarea" name="description" rows="6"></textarea>
                    </div>
                    <div class="col-md-12">
                      <label>New Tag</label>
                      <input type="radio" class="form-control" name="new_tag" value="Yes" checked> Yes
                      <input type="radio" class="form-control" name="new_tag" value="No"> No
                    </div>
                </div>
              </div>
            </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
<script>
  getsubcategory();
function getsubcategory()
{
    let category_id=$('#category_id').val();
    let subcategory_id = "{{request()->subcategory_id ?? ''}}";

    $.ajax({
        type: "GET",
        url: "{{ route('public-content.sub-category') }}",
        data: {category_id:category_id,subcategory_id:subcategory_id},
        success: function (data) {
            $('#sub_category_id').html(data);
        },
        error: function (data) {
            //console.log(data);
        }
    });
}

</script>
@endsection
