@extends('layouts.app')
@section('title','Edit Public Content')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Content</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Content</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
    @php
        $redirect = request()->redirect ?? '';
        if(isset($redirect) && $redirect!='')
        {
          $redirectUrl = route($redirect.'.show',request()->subcategory_id).'?category_id='.request()->category_id;
        }
        else
        {
          $redirectUrl = route('public-content.index');
        }

      @endphp

        <div class="btn-group">
            <a href="{{$redirectUrl}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('public-content.update',$content->id)}}" method="POST" enctype='multipart/form-data'>
            @method('PUT')
            <!-- For validation comment on -->
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Content</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <input type="hidden" name="redirect" value="{!! request('redirect') ?? '' !!}">
                      <label>Category Name<span class="text-danger">*</span></label>
                      <select class="single-select" name="public_content_category_id" id="category_id" onchange="getsubcategory()">
                        <option value=" ">--Select Category--</option>
                        @foreach($category as $cate)
                        <option value="{{$cate->id}}" @if(isset($content->public_content_category_id) && $content->public_content_category_id==$cate->id){{'selected'}}@endif>{{$cate->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-12">
                      <label>Sub Category Name<span class="text-danger">*</span></label>
                      <select class="single-select" name="sub_category_id" id="sub_category_id">
                        <option value=" ">--Select Sub Category--</option>
                        @foreach($SubaCategory as $sub)
                          <option value="{{$sub->id}}" @if(isset($content->sub_category_id) && $content->sub_category_id==$sub->id){{'selected'}}@endif>{{$sub->sub_category_name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-12">
                      <label>Title</label>
                      <input type="text" class="form-control" placeholder="Title" aria-label="title" name="title" value="{{$content->title}}">
                    </div>
                    <div class="col-md-12">
                      <label>link</label>
                      <input type="text" class="form-control" placeholder="Link" aria-label="link" name="link" value="{{$content->link}}">
                    </div>


                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Update Public Content</button>
                  </div>
                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Content Info</h5>
                    <hr class="mb-0">
                    <div class="col-md-6">
                      <label>Image Files <span class="text-danger"></span></label>
                      <input type="file" class="form-control" placeholder="" aria-label="files" name="images" accept="image/*">
                    </div>
                    @if(isset($content->files))
                     <div class="col-md-6">
                        <img src="{{getTempUrl($content->files)}}" style="width:50px;height:50px">
                    </div>
                    @endif
                    <div class="col-md-6">
                      <label>Pdf Files </label>
                      <input type="file" class="form-control" placeholder="" aria-label="files" name="pdf_file" accept=".pdf">
                    </div>
                    @if(isset($content->pdf_file))
                     <div class="col-md-6">
                        <a href="{{getTempUrl($content->pdf_file)}}" class="btn btn-info mt-4" target="_blank">View PDF</a>
                    </div>
                    @endif
                    <div class="col-md-12">
                      <label>Prority</label>
                      <input type="text" class="form-control" placeholder="Prority" aria-label="priority_status" name="priority_status" value="{{$content->prority_status}}">
                    </div>

                    <div class="col-md-12">
                      <label>Description</label>
                      <textarea class="form-textarea" rows="6" name="description">{{$content->description}}</textarea>
                    </div>
                    <div class="col-md-12">
                      <label>New Tag</label>
                      <input type="radio" class="form-control" name="new_tag" value="Yes" @if(isset($content->new_tag) && $content->new_tag=='Yes'){{'checked'}}@endif> Yes
                      <input type="radio" class="form-control" name="new_tag" value="No" @if(isset($content->new_tag) && $content->new_tag=='No'){{'checked'}}@endif> No
                    </div>
                </div>
              </div>
            </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>


<script>
function getsubcategory()
{
    let category_id=$('#category_id').val();

    $.ajax({
        type: "POST",
        url: "{{ route('public-content.sub-category') }}",
        data: {category_id:category_id},
        success: function (data) {
            $('#sub_category_id').html(data);
        },
        error: function (data) {
            //console.log(data);
        }
    });
}

</script>



@endsection
