<form class="g-3 row auto-width" action="{{route('branches.store')}}" method="POST" enctype='multipart/form-data'>
  <!-- For validation comment on -->
  @csrf
  <div class="col-md-12 col-sm-12">

    <div class="g-3 row">
      <div class="col-md-12">
        <label>Title <span class="text-danger">*</span></label>
        <input type="text" class="form-control" placeholder="Title" aria-label="title" name="title">
      </div>
      <div class="col-md-12">
        <label for="validationCustomOrder" class="form-label">Type <span class="text-danger">*</span></label>
        <select class="single-select form-control" id="branch_type_id" name="branch_type_id" required>
          @foreach ($types as $key => $type)
          <option value="{!! $type->id !!}">{!! $type->name !!}</option>
          @endforeach
        </select>
        @if ($errors->has('branch_type_id'))
        <span class="text-danger">{{ $errors->first('branch_type_id') }}</span>
        @endif
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
      </div>
      <div class="col-md-6">
        <label>Phone <span class="text-danger">*</span></label>
        <input type="text" class="form-control" placeholder="Phone" aria-label="title" name="phone">
      </div>
      <div class="col-md-6">
        <label>Email <span class="text-danger">*</span></label>
        <input type="text" class="form-control" placeholder="Email" aria-label="title" name="email">
      </div>
      <div class="col-md-6">
        <label>Image <span class="text-danger">*</span></label>
        <input type="file" class="form-control" placeholder="icon" aria-label="icon" name="cover_image">
      </div>
      <div class="col-md-6">
        <label for="priority" class="form-label">Priority </label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
      </div>
      <div class="col-md-12">
        <label>Google Map <span class="text-danger"></span></label>
        <input type="text" class="form-control" placeholder="Google Map Link" aria-label="title" name="google_map">
      </div>
      <div class="col-md-12">
        <label>Address</label>
        <textarea class="form-textarea" placeholder="address" name="address"></textarea>
      </div>
    </div>
  </div>
</form>