@extends('layouts.app')
@section('title','Notice')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Notice</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Update Notice</li>
            </ol>
        </nav>
    </div>

    @php $redirect  = request()->redirect??'';
         $course_id = request()->id??'';
         $backUrl   = isset(request()->redirect) && request()->redirect!='' ? (route('courses.show',$course_id)) : route('notices.index');
    @endphp

    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{$backUrl}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="g-3 row auto-width notices" action="{{ route('notices.update', $data->id) }}" method="POST" enctype='multipart/form-data' id="update_notice">
                        @method('patch')
                        @csrf
                        <!-- For validation comment on -->
                        <div class="col-md-6 col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="g-3 row">
                                        <h5 class="mb-0">Notice Detail</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <label for="notice_title" class="form-label">Notice Title <span class="text-danger"><b>*</b></span></label>
                                            <input type="text" class="form-control" id="notice_title" value="{{$data->notice_title}}" name="notice_title" aria-describedby="inputGroupPrepend" placeholder="Notice Title" required>
                                            <span class="text-danger error_notice_title" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="form-label" id="notice_file">Notice File </label>
                                            <input type="file" class="form-control" id="notice_file" name="notice_file" aria-describedby="inputGroupPrepend" required placeholder="Enter Notice File" value="{{$data->notice_file}}">
                                            <span class="text-danger error_notice_file" style="display: none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <label>Notice Description</label>
                                            <textarea type="text" class="form-textarea" placeholder="Notice Description" name="description">{{$data->description}}</textarea>
                                        </div>

                                        <div class="d-grid gap-2">
                                            <button class="btn btn-primary save_notice" type="button"><i class="bx bx-save"></i> Save Notice</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="g-3 row">
                                        <h5 class="mb-0">Additional Details</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-6">
                                            <label>Start Date<span class="text-danger">*</span></label>
                                            <input type="text" id="start_date" class="form-control" value="{{formatedDate($data->start_date)}}" placeholder="Start" name="start_date" readonly>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Expire Date</label>
                                            <input type="text" id="expiry_date" class="form-control" placeholder="Expiry Date" name="expiry_date" value="{{formatedDate($data->expiry_date)}}" readonly>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="page_id" class="form-label">Page </label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="page_id">
                                                    <option value="">-- Select Page --</option>
                                                    @foreach($page as $list)
                                                    <option value="{{ $list->id }}" {{ $list->id == $data->page_id ? 'selected':'' }}>{{ $list->title }}</option>
                                                    @endforeach
                                                </select>
                                                {{-- <div class="input-group-append" style="margin: auto 10px;">
                                <button class="btn btn-success add_btn" id="create_tax_category" type="button"> + </button>
                            </div> --}}
                                            </div>
                                            <span class="text-danger error_page" style="display: none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="notice_type_id" class="form-label">Notice Type </label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="notice_type_id">
                                                    @foreach($notice_type as $list)
                                                    <option value="{{ $list->id }}" {{ $list->id == $data->notice_type_id ? 'selected':'' }}>{{ $list->title }}</option>
                                                    @endforeach
                                                </select>
                                                {{-- <div class="input-group-append" style="margin: auto 10px;">
                                <button class="btn btn-success add_btn" id="create_tax_category" type="button"> + </button>
                            </div> --}}
                                            </div>
                                            <span class="text-danger error_notice_type_id" style="display: none;">This field is required.</span>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label" id="page_url">Page Url </label>
                                            <input type="text" class="form-control" id="page_url" name="page_url" aria-describedby="inputGroupPrepend" required placeholder="Enter Page Url" value="{{$data->page_url}}">
                                            <span class="text-danger error_notice_file" style="display: none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="priority" class="form-label">Priority </label>
                                            <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{{$data->priority}}">
                                            <span class="text-danger error_priority" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">Flash Notice </label><br>
                                            <input name="is_flash_notice" class="form-check-inputFeatured btn-lg is_flash_notice" type="checkbox" id="is_flash_notice" value="{{ ($data->is_flash_notice==1)?1:0 }}" {{ ($data->is_flash_notice==1)?'checked':'' }}>
                                            {{-- @if ($errors->has('is_flash_notice'))
                        <span class="text-danger">{{ $errors->first('is_flash_notice') }}</span>
                                            @endif --}}
                                            <span class="text-danger error_is_flash_notice" style="display: none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">New Flag </label><br>
                                            <input name="new_flag" class="form-check-inputFeatured btn-lg new_flag" type="checkbox" id="new_flag" value="{{ ($data->new_flag==1)?1:0 }}" {{ ($data->new_flag==1)?'checked':'' }}>
                                            {{-- @if ($errors->has('new_flag'))
                        <span class="text-danger">{{ $errors->first('new_flag') }}</span>
                                            @endif --}}
                                            <span class="text-danger error_new_flag" style="display: none;">This field is required.</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
    $('#is_flash_notice').change(function() {
        if ($(this).is(':checked')) {
            $(this).val(1);
        } else {
            $(this).val(0);
        }
    });
    $('#new_flag').change(function() {
        if ($(this).is(':checked')) {
            $(this).val(1);
        } else {
            $(this).val(0);
        }
    });

    function formatDate(date) {
        const options = {
            day: '2-digit',
            month: '2-digit',
            year: 'numeric'
        };
        return new Date(date).toLocaleDateString(undefined, options).replace(/\//g, '-');
    }

    var startdate = "{{$data->start_date??''}}";
    if (startdate != '') {
        var currentDate = startdate;
    } else {
        var currentDate = new Date().toISOString().split('T')[0];
    }


    $('#start_date').datepicker({
        dateFormat: 'dd-mm-yy' // Set the desired date format
    }).val(formatDate(currentDate))
    .on('changeDate', function (ev) {
         $(this).datepicker('hide');
    })
    .on('focusout', function (ev) {
         $(this).datepicker('hide');
    });

    $(function() {
        $('#expiry_date').datepicker();
    });

    $(document).on('click', '.save_notice', function(e) {
        e.preventDefault();


        $('.error_notice_title').hide();
        $('.error_start_date').hide();
        var error = 0;


        if ($('input[name="notice_title"]').val() == null || $('input[name="notice_title"]').val().trim() == '') {
            $('.error_notice_title').show();
            error = 1;
        }


        if (error == 0) {
            let formdata = new FormData($('#update_notice')[0]);
            $.ajax({
                    url: "{{ route('notices.update', $data->id) }}",
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            window.location.href = "{{ $backUrl }}";
                            // Replace with the URL you want to redirect to
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
        }

        error = 1;

    })
</script>
@endsection
