@extends('layouts.app')
@section('title','Edit Photo Gallery')
@section('pages')
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Photo Gallery</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Edit Photo Gallery</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('photos-gallery.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('photos-gallery.update',$TblPhotoGallery->id)}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Title <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Title" aria-label="title" name="title" value="{{$TblPhotoGallery->title}}">
                    </div>
                    <div class="col-md-12">
                      <label>Sub Title</label>
                      <input type="text" class="form-control" placeholder="Sub title" aria-label="sub_title" name="sub_title" value="{{$TblPhotoGallery->sub_title}}">
                    </div>
                    <div class="col-md-12">
                      <label>Gallery Type</label>
                      <select class="form-control " name="gallery_type">
                       @foreach($types as $type)
                        <option value="{{$type->id}}" @if($TblPhotoGallery->gallery_type=$type->id){{'selected'}}@endif >{!! $type->type_of_gallery !!}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-12 mt-3">
                      <label>Priority</label>
                      <input type="text" class="form-control" id="Priority" name="priority" placeholder="Priority" value="{{$TblPhotoGallery->priority}}">
                    </div>


                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Update Photo Gallery</button>
                  </div>
                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Images</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Date</label>
                      <input type="text" class="form-control datepicker" aria-label="date" name="date" value="{{$TblPhotoGallery->date}}">
                    </div>
                    <div class="col-md-12">
                      <label>Gallery Keywords</label>
                      <input type="text" class="form-control" aria-label="gallery_keywords" placeholder="Gallery Keywords" name="gallery_keywords" value="{{$TblPhotoGallery->gallery_keywords}}">
                    </div>
                    @if(isset($TblPhotoGallery->cover_pic))
                      <div class="col-md-12">
                        <label>Cover Image</label>
                        <img src="{{getTempUrl($TblPhotoGallery->cover_pic)}}" height="100px" width="100px">
                      </div>
                    @endif

                    <div class="col-md-12">
                    <label>Cover Image (600*450)</label>
                      <input type="file" class="form-control" name="cover_pic">
                    </div>
                    <div class="col-md-12">
                      <label>Description</label>
                      <textarea type="text" class="form-textarea" placeholder="Description" aria-label="description" name="details">{{$TblPhotoGallery->details}}</textarea>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
  $('.datepicker').datepicker();
</script>
@endsection
