@extends('layouts.app')
@section('title','Show Photo Gallery')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.css" integrity="sha512-nNlU0WK2QfKsuEmdcTwkeh+lhGs6uyOxuUs+n+0oXSYDok5qy0EI0lt01ZynHq6+p/tbgpZ7P+yUb+r71wqdXg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Photo Gallery</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Show Photo Gallery</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <div class="g-3 row auto-width">
            <!-- For validation comment on -->
            <div class="col-md-6 col-sm-6">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                      <div class="col-md-12">
                        <p><b>Title:</b> {{$TblPhotoGallery->title}}<br>
                          <b>Description:</b> {{$TblPhotoGallery->title}}<br>
                          <b>Sub Title:</b> {{$TblPhotoGallery->sub_title}}<br>
                          <b>Gallery Keywords:</b> {{$TblPhotoGallery->gallery_keywords}}</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <div class="col-md-6 col-sm-6">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Cover Image</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <p><b>Image:</b></p>
                      @if(isset($TblPhotoGallery->cover_pic))
                          <a href="{{getTempUrl($TblPhotoGallery->cover_pic)}}" data-fancybox="gallery" data-caption="{{$TblPhotoGallery->title ?? ''}}">
                              <img src="{{getTempUrl($TblPhotoGallery->cover_pic)}}" style="height:150px;width:150px;">
                          </a>
                      @endif
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
                <div class="card">
                 <div class="card-body">
                  <div class="g-3 row">
                    <div class="col-md-12">
                        <h5 class="mb-0">Details</h5>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Image Name</th>
                                        <th>Image</th>
                                        <th>Priority</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($TblPhotoGallery->getImagesAll)>0)
                                    @foreach($TblPhotoGallery->getImagesAll as $list)
                                    <tr>
                                    <td>{{$list->image_name}}</td>
                                    <td>
                                      @if(isset($list->image))
                                          <a href="{{getTempUrl($list->image)}}" data-fancybox="gallery" data-caption="{{$list->image_name ?? ''}}">
                                              <img src="{{getTempUrl($list->image)}}" style="height:60px;width:60px;">
                                          </a>
                                      @endif
                                    </td>
                                    <td>{{$list->priority}}</td>
                                    <td> 
                                        <a href="#" data-url="{{route('photos-gallery.deleteitem')}}" data-id="{{$list->id}}" class="btn btn-danger deleteData" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                        <i class="bi bi-trash-fill text-white"></i>
                                        </a>
                                    </td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr align="center"><td colspan="4"><b>No Data Found</b></td></tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
              </div>
            </div>
            </div>
        </div>
      </div>
    </div>
  </div>

</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.js" integrity="sha512-j7/1CJweOskkQiS5RD9W8zhEG9D9vpgByNGxPIqkO5KrXrwyDAroM9aQ9w8J7oRqwxGyz429hPVk/zR6IOMtSA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
@endsection