@extends('layouts.app')
@section('title','New Page')
@section('pages')
    <style type="text/css">
        .tox .tox-statusbar__text-container {
            display: none !important;
        }
        .tox-notifications-container{
          display: none !important;
        }
    </style>
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Pages</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">New Page</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('pages-setting.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('pages-setting.store')}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                      <div class="mb-3">
                          <label for="name" class="form-label">Title</label>
                          <input value="{{ old('title') }}" type="text"
                              class="form-control" name="title" placeholder="Title" required>
                      </div>
                      <div class="mb-3">
                          <label for="name" class="form-label">Short Content</label>
                          <input type="text" class="form-control" name="description" id="description">
                      </div>
                      <div class="mb-3">
                          <label for="name" class="form-label">Video Url</label>
                          <input type="text" class="form-control" name="video_url" id="url">
                      </div>
                        <div class="mb-3">
                          <label for="name" class="form-label">Feature Image Size(1200*320)</label><br>
                          <input type="file" class="form-control" name="image" placeholder="Image">
                        </div>
                  </div>
                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">SEO Details</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                  <div class="mb-3">
                      <label for="name" class="form-label">Meta Title</label>
                      <input value="{{ old('meta_title') }}" type="text" class="form-control" name="meta_title" placeholder="Meta Title (Character Limit 160)" length="160">
                  </div>
                    </div>
                    <div class="col-12">
                  <div class="mb-3">
                      <label for="name" class="form-label">Meta KeyWord</label>
                      <input value="{{ old('meta_key') }}" type="text" class="form-control" name="meta_key" placeholder="Meta KeyWord (Character Limit 200)" length="200">
                  </div>
                  </div>
                  <div class="col-12">
                    <div class="mb-3">
                          <label for="name" class="form-label">Meta Description</label>
                          <input type="text" class="form-control" name="meta_description" placeholder="Meta description (Character Limit 250)" value="{{ old('meta_description') }}" length="250">
                          
                      </div>
                      <div class="mb-3">
                          <label for="name" class="form-label">Meta Url</label>
                          <input value="{{ old('meta_url') }}" type="text" class="form-control" name="meta_url" placeholder="Meta Url">
                      </div>

                      
                    </div>
                </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                  <h5 class="mb-0">Content</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                    <div class="mb-3">
                      <label for="name" class="form-label">Content</label>
                      <textarea class="form-control" name="body" id="content"></textarea>
                    </div>
                    </div>
                    <div class="col-12" align="center">
                    <div class="d-grid gap-2 with-50">
                      <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Save Pages</button>
                    </div>
                </div>
                  </div>
                </div>
              </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection

@section('js')
{{-- <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script> --}}
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script type="text/javascript">
       ClassicEditor
        .create( document.querySelector('#content'))
        .then( newEditor => {
            editor = newEditor;
        })
        .catch( error => {
            console.error( error );
        });
        $(".ck-dropdown").find(`[data-cke-tooltip-text='Insert media']`).css("display", "none");

    </script>
@endsection
