@extends('layouts.app')
@section('title','Edit Page')
@section('pages')
{{-- <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet"> --}}
    <style type="text/css">
        .tox .tox-statusbar__text-container {
            display: none !important;
        }
        .tox-notifications-container{
          display: none !important;
        }
    </style>
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Pages</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Edit Page</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('pages-setting.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('pages-setting.update',$Post->id)}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                      <div class="mb-3">
                          <label for="name" class="form-label">Title</label>
                          <input value="{{ $Post->title }}" type="text"
                              class="form-control" name="title" placeholder="Title" required>
                      </div>
                        <div class="mb-3">
                          <label for="name" class="form-label">Short Content</label>
                          <input class="form-control" name="description" id="description" value="{{ $Post->description }}">
                        </div>
                        <div class="mb-3">
                          <label for="name" class="form-label">Video Url</label>
                          <input type="text" class="form-control" name="video_url" id="url" value="{{$Post->video_url??''}}">
                      </div>
                      <div class="mb-3">
                          <label for="name" class="form-label">Banner Image Size</label><br>
                          <input type="file" class="form-control" name="image" placeholder="Image">
                      </div>
                      <div class="mb-3">
                          <label for="name" class="form-label">Banner Image</label><br>
                          <img src="{{getTempUrl($Post->image)}}" style="width: 150px;height:100px">
                      </div>
                    </div>

                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">SEO Details</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                  <div class="mb-3">
                      <label for="name" class="form-label">Meta Title</label>
                      <input value="{{ $Post->meta_title }}" type="text" class="form-control" name="meta_title" placeholder="Meta Title" length="160">
                  </div>
                    </div>
                    <div class="col-12">
                  <div class="mb-3">
                      <label for="name" class="form-label">Meta KeyWord</label>
                      <input value="{{ $Post->meta_key }}" type="text" class="form-control" name="meta_key" placeholder="Meta KeyWord" length="200">
                  </div>
                    </div>
                  <div class="col-12">
                    <div class="mb-3">
                      <label for="name" class="form-label">Meta Description</label>
                      <input class="form-control" name="meta_description" placeholder="Meta description" value="{{ $Post->meta_description }}" length="250">
                  </div>
                  <div class="mb-3">
                      <label for="name" class="form-label">Meta Url</label>
                      <input value="{{ $Post->meta_url }}" type="text" class="form-control" name="meta_url" placeholder="Meta Url">
                  </div>

                  
                </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                  <h5 class="mb-0">Content</h5>
                    <hr class="mb-0">
                    <div class="col-12">
                    <div class="mb-3">
                      <label for="name" class="form-label">Content</label>
                      <textarea class="form-control" name="body" id="content">{{ $Post->body }}</textarea>
                    </div>
                    </div>
                    <div class="col-12" align="center">
                    <div class="d-grid gap-2 with-50">
                      <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Upadate Pages</button>
                    </div>
                </div>
                  </div>
                </div>
              </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection

@section('js')
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script type="text/javascript">
      ClassicEditor
        .create( document.querySelector( '#content') )
        .then( newEditor => {
            editor = newEditor;
        })
        .catch( error => {
            console.error( error );
        });
        $(".ck-dropdown").find(`[data-cke-tooltip-text='Insert media']`).css("display", "none");

    </script>
@endsection
