@extends('layouts.app')
@section('title','Social Media Setting')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Website Setting</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
        <li class="breadcrumb-item active" aria-current="page">Social Media Setting</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('settings.update',$Setting->id)}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Social Media Setting Info</h5>
                    <hr class="mb-0">
                    <div class="col-md-6">
                      <label>Favicon</label>
                      <input type="file" class="form-control" aria-label="" name="favicon">
                    </div>
                    <div class="col-md-6">
                      <label>Favicon <span class="text-danger">*</span></label>
                      <img src="{{$Setting->favicon}}" width="100" height="100">
                    </div>
                    <div class="col-md-12">
                      <label>Facebook</label>
                      <input type="text" class="form-control" placeholder="facebook" aria-label="facebook" name="facebook" value="{{$Setting->facebook}}">
                    </div>
                    <div class="col-md-12">
                      <label>Twitter</label>
                      <input type="text" class="form-control" placeholder="twitter" aria-label="twitter" name="twitter" value="{{$Setting->twitter}}">
                    </div>
                    <div class="col-md-12">
                      <label>Instagram</label>
                      <input type="text" class="form-control" placeholder="instagram" aria-label="instagram" name="instagram" value="{{$Setting->instagram}}">
                    </div>
                    <div class="col-md-12">
                      <label>Youtube</label>
                      <input type="text" class="form-control" placeholder="youtube" aria-label="youtube" name="youtube" value="{{$Setting->youtube}}">
                    </div>
                    <div class="col-md-12">
                      <label>Linkedin</label>
                      <input type="text" class="form-control" placeholder="linkedin" aria-label="linkedin" name="linkedin" value="{{$Setting->linkedin}}">
                    </div>
                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Save Data</button>
                  </div>
                </div>
              </div>
            </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>

@endsection