@extends('layouts.app')
@section('title','Social Media Setting')
@section('pages')

<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Social Media Setting</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{url('dashboard')}}"><i class="bx bx-home-alt"></i></a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">Social Media Setting</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="{{  route('settings.create')}}" class="btn btn-success"> Add New<i class="bx bx-plus"></i></a>
    </div>
  </div>
</div>
<!--end breadcrumb-->

<div class="card shadow-none radius-5 min-height">
  <div class="card-header py-3">
   <div class="row g-3">
     <div class="col-lg-3 col-md-6 me-auto">
       <div class="ms-auto position-relative">
         <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
         <input class="form-control ps-5" type="search" id="search" placeholder="Search Setting">
       </div>
     </div>
     <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length">
       <select class="form-select sorting" id="" name="example_length" aria-controls="example">
         <option value="10">Show: 10</option>
         <option value="30">Show: 30</option>
         <option value="50">Show: 50</option>
       </select>
     </div>
   </div>
 </div>
 
 @include('website-setting.settings.table')
 
 <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
 <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
 <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
</div>

<script>
  $(document).ready(function(){
    function clear_icon(){
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }
    function fetch_data(page, sort_type, sort_by, query){
      $.ajax({
        url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query,
        success:function(data){
          $('#tables').html('');
          $('#tables').html(data);
          $(document).ready(function(){$.switcher();});
        }
      })
    }
    $('body').on('keyup', '#search', function(){
      var query = $('#search').val();
      var column_name = $('.sorting').val();
      var sort_type = $('#hidden_sort_type').val();
      var page = 1?1:(this).attr('href').split('page=')[1];
      fetch_data(page, sort_type, column_name, query);
    });
    $('body').on('change', '.sorting', function(){

      var column_name = $(this).val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      fetch_data(page, reverse_order, column_name, query);
    });
    $('body').on('click', '.pager a', function(event){
      event.preventDefault();
      console.log('url', $(this).attr('href'));
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name = $('.sorting').val()?$('.sorting').val():'';
      var sort_type = $('#hidden_sort_type').val();
      var query = $('#search').val()?$('#search').val():'';
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query);
    });
  });
</script>
@endsection