@extends('layouts.app')
@section('title','Edit Slider')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Home Slider</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Slider</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('sliders.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{ route('sliders.update', $Slider->id) }}" method="POST" enctype='multipart/form-data'>
            @method('patch')
            @csrf
          <!-- For validation comment on -->
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Slider Details</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Slider Title <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Slider Title" aria-label="title" name="title" value="{{$Slider->title}}">
                    </div>
                    <div class="col-md-6">
                      <label>Slider Image (1950*565)<span class="text-danger">*</span></label>
                      <input type="file" class="form-control" name="slider_image">
                    </div>
                    <div class="col-md-6">
                      <img src="{{getTempUrl($Slider->image)}}" style="height: 60px;width:50px">
                    </div>
                    <div class="col-md-12">
                      <label>Priority Status <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Priority Status" aria-label="Priority Status" name="priority_status" value="{{$Slider->priority_status}}">
                    </div>
                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Update Slider</button>
                  </div>
                </div>
              </div>
            </div>
            </div>


            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Slider Additional Info</h5>
                    <hr class="mb-0">
                    <div class="col-md-6">
                      <label>Button1 Title </label>
                      <input type="text" class="form-control" placeholder="Button Title" aria-label="sub_title" name="btn_text" value="{{$Slider->btn_text}}">
                    </div>
                    <div class="col-md-6">
                      <label>Button1 Link </label>
                      <input type="text" class="form-control" placeholder="Button Link" aria-label="sub_title" name="btn_enquiry_link" value="{{$Slider->btn_enquiry_link}}">
                    </div>
                    <div class="col-md-6">
                      <label>Button2 Title </label>
                      <input type="text" class="form-control" placeholder="Button Title" aria-label="sub_title" name="btn2_text" value="{{$Slider->btn2_text}}">
                    </div>
                    <div class="col-md-6">
                      <label>Button2 Link </label>
                      <input type="text" class="form-control" placeholder="Button Link" aria-label="sub_title" name="btn2_enquiry_link" value="{{$Slider->btn2_enquiry_link}}">
                    </div>
                    <div class="col-md-12">
                      <label>Slider Sub Title</label>
                      <textarea class="form-textarea" placeholder="Slider Sub Title" aria-label="sub_title" name="sub_title" rows="4"> {{$Slider->sub_title}}</textarea>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection
