@extends('layouts.app')
@section('title','New Video Gallery')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Video Gallery</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">New Video Gallery</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('videos-gallery.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('videos-gallery.store')}}" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Title <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Title" aria-label="title" name="title">
                    </div>
                    <div class="col-md-12">
                      <label>Description</label>
                      <textarea type="text" class="form-control" placeholder="Description" aria-label="description" name="description"></textarea>
                    </div>
                    <div class="col-md-12">
                      <label>Video Url <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" placeholder="Video Url" aria-label="Video Url" name="video_url">
                    </div>
                    <div class="d-grid gap-2">
                    <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Save Video Gallery</button>
                  </div>
                </div>
              </div>
            </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Images</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label>Priority</label>
                      <input type="text" class="form-control" aria-label="priority" name="priority" value="">
                    </div>
                    <div class="col-md-12">
                    <label>Cover Image (600*450)<span class="text-danger">*</span></label>
                      <input type="file" class="form-control" name="cover_pic">
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
@endsection
