@extends('layouts.app')
@section('title','Edit Photo Gallery')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Website Setting</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
        <li class="breadcrumb-item active" aria-current="page">Edit Photo Gallery</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <div class="g-3 row auto-width">
            <!-- For validation comment on -->
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Basic Details</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-3">
                                <h3><b>Title:</b></h3>
                            </div>
                            <div class="col-md-9">
                                <h5>{{$TblPhotoGallery->title}}</h5>
                            </div>
                            <div class="col-md-3">
                                <h3>Description:</h3>
                            </div>
                            <div class="col-md-9">
                                <h5>{{$TblPhotoGallery->details}}</h5>
                            </div>
                            <div class="col-md-3">
                                <h3>Sub Title:</h3>
                            </div>
                            <div class="col-md-9">
                                <h5>{{$TblPhotoGallery->sub_title}}</h5>
                            </div>
                            <div class="col-md-3">
                                <h3>Gallery Keywords:</h3>
                            </div>
                            <div class="col-md-9">
                                <h5>{{$TblPhotoGallery->gallery_keywords}}</h5>
                            </div>
                            <div class="col-md-3">
                                <h3>Image:</h3>
                            </div>
                            <div class="col-md-9">
                                <h5><img src="{{$TblPhotoGallery->cover_pic}}" class="img-fluid" width="150px" height="150px"></h5>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <h3>Details</h3>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Image Name</th>
                                        <th>Image</th>
                                        <th>Priority</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($TblPhotoGallery->getImagesAll)>0)
                                    @foreach($TblPhotoGallery->getImagesAll as $list)
                                    <tr>
                                    <td>{{$list->image_name}}</td>
                                    <td><img src="{{$list->image}}" width="80px" height="80px"></td>
                                    <td>{{$list->priority}}</td>
                                    <td> 
                                        <a href="#" data-url="{{route('photos-gallery.deleteitem')}}" data-id="{{$list->id}}" class="btn btn-danger deleteData" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                        <i class="bi bi-trash-fill text-white"></i>
                                        </a>
                                    </td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr align="center"><td colspan="4"><b>No Data Found</b></td></tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
              </div>
            </div>
            </div>
        </div>
      </div>
    </div>
  </div>

</div>
</div>
@endsection