<?php

use App\Http\Controllers\AbdmApiCallsController;
use Illuminate\Support\Facades\Route;

/******************************* Main Route *****************************/
Route::resource('abdm-api-calls', AbdmApiCallsController::class);

/******************************* Change Status *****************************/

Route::get('abdm-api-calls-index/{id?}', [AbdmApiCallsController::class , 'index'])->name('abdm-api-calls-index');

Route::post('abdm-api-calls/changeStatus', [AbdmApiCallsController::class, 'changeStatus'])
    ->name('abdm-api-calls-changestatus');

/******************************* CRUD Operations *****************************/
Route::get('abdm-api-calls-create/{id?}', [AbdmApiCallsController::class, 'createAbdmApiCalls'])
    ->name('abdm-api-calls-create');

Route::post('abdm-api-calls-store/{id?}', [AbdmApiCallsController::class, 'storeAbdmApiCalls'])
    ->name('abdm-api-calls-store');

Route::put('abdm-api-calls-update/{id?}', [AbdmApiCallsController::class, 'updateAbdmApiCalls'])
    ->name('abdm-api-calls-update');



// EXCEL
Route::get('abdm-api-calls-import/modal', [AbdmApiCallsController::class, 'importForm'])->name('abdm-api-calls-import.modal');
Route::post('abdm-api-calls-import/store', [AbdmApiCallsController::class, 'importBulkAbdmApiCalls'])->name('abdm-api-calls-import.store');
Route::get('abdm-api-calls-import/create', [AbdmApiCallsController::class, 'importAbdmApiCallsForm'])->name('abdm-api-calls-import.create');
Route::get('abdm-api-calls-import/edit/{id}', [AbdmApiCallsController::class, 'editAbdmApiCalls'])->name('abdm-api-calls-import.edit');
Route::post('abdm-api-calls-import/update/{id}', [AbdmApiCallsController::class, 'updateAbdmApiCallImport'])->name('abdm-api-calls-import.update');
Route::post('abdm-api-calls-import/proceed', [AbdmApiCallsController::class, 'importAbdmApiCalls'])->name('abdm-api-calls-import.proceed');
Route::get('/abdm-api-calls-import-clear-data', [AbdmApiCallsController::class, 'clearData'])->name('abdm-api-calls-import.clear-data');
Route::post('abdm-api-calls-import/delete', [AbdmApiCallsController::class, 'importDestroy'])->name('abdm-api-calls-import.destroy');