<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AcademicManager\CourseTypesController;
use App\Http\Controllers\AcademicManager\CourseLevelsController;
use App\Http\Controllers\AcademicManager\LanguagesController;
use App\Http\Controllers\AcademicManager\CourseCategoriesController;
use App\Http\Controllers\AcademicManager\TagsController;
use App\Http\Controllers\AcademicManager\CoursesController;
use App\Http\Controllers\AcademicManager\ClassesController;
use App\Http\Controllers\AcademicManager\SectionsController;
use App\Http\Controllers\AcademicManager\BooksController;
use App\Http\Controllers\AcademicManager\BlogCategoriesController;
use App\Http\Controllers\AcademicManager\SubjectsController;
use App\Http\Controllers\AcademicManager\DoubtSessionsController;

   // Course Types
   Route::resource('course-types', CourseTypesController::class);
   Route::any('course-types/status', [CourseTypesController::class, 'changeStatus'])->name('course-types.changeStatus');
   // Course Levels
   Route::resource('course-levels', CourseLevelsController::class);
   Route::any('course-levels/status', [CourseLevelsController::class, 'changeStatus'])->name('course-levels.changeStatus');
   // Languages
   Route::resource('languages', LanguagesController::class);
   Route::any('languages/status', [LanguagesController::class, 'changeStatus'])->name('languages.changeStatus');
   // Course Categories
   Route::resource('course-categories', CourseCategoriesController::class);
   Route::any('course-categories/status', [CourseCategoriesController::class, 'changeStatus'])->name('course-categories.changeStatus');
   // Tags
   Route::resource('tags', TagsController::class);
   Route::any('tags/status', [TagsController::class, 'changeStatus'])->name('tags.changeStatus');
   // Courses
   Route::resource('courses', CoursesController::class);
   Route::any('courses/status', [CoursesController::class, 'changeStatus'])->name('courses.changeStatus');
   Route::any('course/{id}/assignments', [CoursesController::class, 'courseAssignments'])->name('course.assignments');
   Route::any('assignments/{id}/destroy', [CoursesController::class, 'courseDestroy'])->name('assignments.destroy');
   Route::any('assignments/create', [CoursesController::class, 'createAssignment'])->name('assignments.create');
   Route::any('assignments/store', [CoursesController::class, 'storeAssignment'])->name('assignments.store');
   Route::any('assignments/edit/{id}', [CoursesController::class, 'editAssignment'])->name('assignments.edit');
   Route::any('assignments/update/{id}', [CoursesController::class, 'update'])->name('assignments.update');
   Route::any('get-sections', [CoursesController::class, 'getSections'])->name('class.sections');

   Route::any('course/notice/{course_id}',[CoursesController::class,'courseNotice'])->name('course.notice');
   // Classes
   Route::resource('classes', ClassesController::class);
   Route::any('classes/status', [ClassesController::class, 'changeStatus'])->name('classes.changeStatus');
   // Sections
   Route::resource('sections', SectionsController::class);
   Route::any('sections/status', [SectionsController::class, 'changeStatus'])->name('sections.changeStatus');
   Route::resource('books', BooksController::class);
   Route::any('books/status', [BooksController::class, 'changeStatus'])->name('books.changeStatus');
   Route::any('books/images/{id}', [BooksController::class, 'bookImages'])->name('books.images');
   Route::any('book-image/changestatus', [BooksController::class, 'imageStatus'])->name('book-image.changestatus');
   Route::any('book-image/delete', [BooksController::class, 'imageDestroy'])->name('book-image.destroy');
   Route::any('book-image/create/{id}', [BooksController::class, 'imageCreate'])->name('book.image.create');
   Route::any('/store-book-image', [BooksController::class, 'storeImage'])->name('book-image.store');
   Route::any('/edit-image/{id}', [BooksController::class, 'editImage'])->name('book.image.edit');
   Route::any('/update-image/{id}', [BooksController::class, 'updateImage'])->name('book.image.update');
   Route::any('import/books/view', [BooksController::class, 'importView'])->name('books.import.view');
   Route::any('import/books/store', [BooksController::class, 'import'])->name('books.import.store');
   Route::any('view/genere', [BooksController::class, 'genere'])->name('genere.view');
   Route::any('view/author', [BooksController::class, 'author'])->name('author.view');
   Route::any('view/publisher', [BooksController::class, 'publisher'])->name('publisher.view');
   Route::any('view/language', [BooksController::class, 'language'])->name('language.view');
   Route::any('view/stream', [BooksController::class, 'stream'])->name('stream.view');
   Route::get('/getisbn',[BooksController::class,'genearte_isbn'])->name('books.getisbn');
   // Blog Categories
   Route::resource('blog-categories', BlogCategoriesController::class);
   Route::any('blog-categories/status', [BlogCategoriesController::class, 'changeStatus'])->name('blog-categories.changeStatus');

   // LMS - Routes
   Route::resource('subjects', SubjectsController::class);
   Route::any('subjects/status', [SubjectsController::class, 'changeStatus'])->name('subjects.changeStatus');
   Route::resource('doubt-sessions',DoubtSessionsController::class);
?>