<?php

use App\Http\Controllers\Accounting\FinancialReportsController;
use App\Http\Controllers\Accounts\AccountAddressesController;
use App\Http\Controllers\Accounts\AccountAttachmentsController;
use App\Http\Controllers\Accounts\AccountBanksController;
use App\Http\Controllers\Accounts\AccountContactsController;
use App\Http\Controllers\Accounts\AccountDivisionsController;
use App\Http\Controllers\Accounts\AccountImagesController;
use App\Http\Controllers\Accounts\AccountingGroupsController;
use App\Http\Controllers\Accounts\AccountingTypesController;
use App\Http\Controllers\Accounts\AccountLicensesController;
use App\Http\Controllers\Accounts\AccountPaymentsController;
use App\Http\Controllers\Accounts\AccountsController;
use App\Http\Controllers\Accounts\AccountSettlementTypesController;
use App\Http\Controllers\Accounts\AccountTitlesController;
use App\Http\Controllers\Accounts\AddressTypesController;
use App\Http\Controllers\Accounts\GendersController;
use App\Http\Controllers\Accounts\MaritalStatusesController;
use App\Http\Controllers\Accounts\BloodGroupsController;
use App\Http\Controllers\Accounts\LicenseTypesController;
use App\Http\Controllers\Accounts\MasterCategoriesController;
use App\Http\Controllers\Accounts\MasterTypesController;
use App\Http\Controllers\Accounts\RelationTypesController;
use App\Http\Controllers\Accounts\TaxRegisterCategoriesController;
use App\Http\Controllers\Accounts\TempAccountImportController;
use Illuminate\Support\Facades\Route;

   /*
    * ACCOUNTS START HERE
    */

   /**************************** Accounting Types *********************************/
   Route::resource('accounting-types', AccountingTypesController::class);
   Route::any('accounting-types/delete', [AccountingTypesController::class, 'destroy'])->name('accounting-types.destroy');
   Route::any('accounting-types/changestatus', [AccountingTypesController::class, 'changestatus'])->name('accounting-types.changestatus');
   Route::any('accounting-types/changedefault', [AccountingTypesController::class, 'changedefault'])->name('accounting-types.changedefault');

   /**************************** Accounts Addresses *********************************/
   Route::resource('account-addresses', AccountAddressesController::class);
   Route::group(['prefix' => 'account-addresses'], function () {
      Route::any('/delete', [AccountAddressesController::class, 'destroy'])->name('account-addresses.destroy');
      Route::any('/create-address/{id}', [AccountAddressesController::class, 'createAddress'])->name('account-addresses.create_address');
      Route::any('/changestatus', [AccountAddressesController::class, 'changestatus'])->name('account-addresses.changestatus');
      Route::any('/changedefault', [AccountAddressesController::class, 'changedefault'])->name('account-addresses.changedefault');
   });
    Route::resource('account-relative', AccountAddressesController::class);

   /**************************** Accounts attachments *********************************/
   Route::resource('account-attachments', AccountAttachmentsController::class);
   Route::group(['prefix' => 'account-attachments'], function () {
      Route::any('/delete', [AccountAttachmentsController::class, 'destroy'])->name('account-attachments.destroy');
      Route::any('/create-attachments/{id}', [AccountAttachmentsController::class, 'create'])->name('account-attachments.create_attachments');
      Route::any('/changestatus', [AccountAttachmentsController::class, 'changestatus'])->name('account-attachments.changestatus');
   });

   /**************************** Accounts Banks *********************************/
   Route::resource('account-banks', AccountBanksController::class);
   Route::group(['prefix' => 'account-banks'], function () {
      Route::any('/delete', [AccountBanksController::class, 'destroy'])->name('account-banks.destroy');
      Route::any('/create-bank/{id}', [AccountBanksController::class, 'create'])->name('account-banks.create_bank');
      Route::any('/changestatus', [AccountBanksController::class, 'changestatus'])->name('account-banks.changestatus');
      Route::any('/changedefault', [AccountBanksController::class, 'changedefault'])->name('account-banks.changedefault');
   });

   /********************************** Clients *********************************************/
   Route::resource('contacts', AccountContactsController::class);
   Route::any('contacts/delete', [AccountContactsController::class, 'destroy'])->name('contacts.destroy');
   Route::get('contact-model', [AccountContactsController::class, 'createModel'])->name('contact-model');
   Route::any('get-contacts', [AccountContactsController::class, 'getContacts'])->name('get-contacts');

   /**************************** Account Divisions *********************************/
   Route::resource('account-divisions', AccountDivisionsController::class);
   Route::group(['prefix' => 'account-divisions'], function () {
      Route::any('/delete', [AccountDivisionsController::class, 'destroy'])->name('account-divisions.destroy');
      Route::any('/changestatus', [AccountDivisionsController::class, 'changeStatus'])->name('account-divisions.changestatus');
   });

   /**************************** Accounts images *********************************/
   Route::resource('account-images', AccountImagesController::class);
   Route::group(['prefix' => 'account-images'], function () {
      Route::any('/delete', [AccountImagesController::class, 'destroy'])->name('account-images.destroy');
      Route::any('/create-images/{id}', [AccountImagesController::class, 'create'])->name('account-images.create_images');
   });

   /**************************** Accounting Groups *********************************/
   Route::resource('accounting-groups', AccountingGroupsController::class);
   Route::any('accounting-groups/delete', [AccountingGroupsController::class, 'destroy'])->name('accounting-groups.destroy');
   Route::any('accounting-groups/change-payment-mode-status', [AccountingGroupsController::class, 'changePaymentModeStatus'])->name('accounting-groups.change-payment-mode-status');


   /**************************** Accounts license *********************************/
   Route::resource('account-licenses', AccountLicensesController::class);
   Route::group(['prefix' => 'account-licenses'], function () {
      Route::any('/delete', [AccountLicensesController::class, 'destroy'])->name('account-licenses.destroy');
      Route::any('/create-license/{id}', [AccountLicensesController::class, 'create'])->name('account-licenses.create_license');
      Route::any('/changestatus', [AccountLicensesController::class, 'changestatus'])->name('account-licenses.changestatus');
   });

   /**************************** Accounts payments *********************************/
   Route::resource('account-payments', AccountPaymentsController::class);
   Route::group(['prefix' => 'account-payments'], function () {
      Route::any('/delete', [AccountPaymentsController::class, 'destroy'])->name('account-payments.destroy');
      Route::any('/create-payment/{id}', [AccountPaymentsController::class, 'create'])->name('account-payments.create_payment');
      Route::any('/changestatus', [AccountPaymentsController::class, 'changestatus'])->name('account-payments.changestatus');
      Route::any('/changedefault', [AccountPaymentsController::class, 'changedefault'])->name('account-payments.changedefault');
   });

   /**************************** Accounts *********************************/
   Route::resource('accounts', AccountsController::class);
   
   Route::any('accounts/changestatus', [AccountsController::class, 'changestatus'])->name('accounts.changestatus');
   Route::resource('relation-types', RelationTypesController::class);
   Route::any('relation-types/changestatus', [RelationTypesController::class, 'changeStatus'])->name('relation-types.changeStatus');
   Route::any('accounts/delete', [AccountsController::class, 'destroy'])->name('accounts.destroy');
   Route::any('accounts/addresses/{id}', [AccountsController::class, 'addresses'])->name('accounts.addresses');
   Route::any('accounts/relatives/{id}', [AccountsController::class, 'relatives'])->name('accounts.relatives');
   Route::any('accounts/banks/{id}', [AccountsController::class, 'accountBanks'])->name('accounts.banks');
   Route::any('accounts/licenses/{id}', [AccountsController::class, 'accountLicenses'])->name('accounts.licenses');
   Route::any('accounts/payments/{id}', [AccountsController::class, 'accountPayments'])->name('accounts.payments');
   Route::any('accounts/attachments/{id}', [AccountsController::class, 'accountAttachments'])->name('accounts.attachments');
   Route::any('accounts/images/{id}', [AccountsController::class, 'accountImages'])->name('accounts.images');
   Route::any('assignAdminRoles', [AccountsController::class, 'assignAdminRoles'])->name('assignAdminRoles');
   Route::get('patient-account-create', [AccountsController::class, 'createPatient'])->name('patient-account-create');
   Route::post('patient-account-store', [AccountsController::class, 'storePatient'])->name('patient-account-store');
   Route::get('doctor-account-create', [AccountsController::class, 'createDoctor'])->name('doctor-account-create');
   Route::post('doctor-account-store', [AccountsController::class, 'storeDoctor'])->name('doctor-account-store');
   Route::get('referral-lab-account-create', [AccountsController::class, 'createReferral'])->name('referral-lab-account-create');
   Route::post('referral-lab-account-store', [AccountsController::class, 'storeReferral'])->name('referral-lab-account-store');
   Route::get('collection-agent-account-create', [AccountsController::class, 'createCollectionAgent'])->name('collection-agent-account-create');
   Route::post('collection-agent-account-store', [AccountsController::class, 'storeCollectionAgent'])->name('collection-agent-account-store');
   Route::get('export-accounts-form', [AccountsController::class, 'exportAccountsForm'])->name('export-accounts-form');
   Route::get('export-accounts', [AccountsController::class, 'exportAccounts'])->name('export-accounts');
   Route::post('/get-account-type-person', [AccountsController::class, 'accountTypePerson'])->name('get-account-type-person');


   Route::get('party-account-create', [AccountsController::class, 'createParty'])->name('party-account-create');
   Route::post('party-account-store', [AccountsController::class, 'storeParty'])->name('party-account-store');
   Route::get('party-account-edit/{id}', [AccountsController::class, 'partyEdit'])->name('party-account-edit');
   Route::post('party-account-update/{id}', [AccountsController::class, 'updateParty'])->name('party-account-update');


   /**************************** Accounts Relatives *********************************/
    Route::any('/edit-relative/{id}', [AccountsController::class, 'editRelative'])->name('accounts.relative.edit');
    Route::any('/update-relative/{id}', [AccountsController::class, 'updateRelative'])->name('accounts.relative.update');
    Route::any('/create-relative/{id}', [AccountsController::class, 'createRelative'])->name('accounts.relative.create');
    Route::any('/store-relative', [AccountsController::class, 'storeRelative'])->name('accounts.relative.store');
    Route::any('relatives/changestatus', [AccountsController::class, 'relativeChangestatus'])->name('accounts.relatives.changestatus');
    Route::any('relatives/delete', [AccountsController::class, 'relativeDestroy'])->name('account.relatives.destroy');

   /**************************** License Types *********************************/
   Route::resource('account-settlement-types', AccountSettlementTypesController::class);
   Route::group(['prefix' => 'account-settlement-types'], function () {
      Route::any('/delete', [AccountSettlementTypesController::class, 'destroy'])->name('account-settlement-types.destroy');
      Route::any('/changestatus', [AccountSettlementTypesController::class, 'changestatus'])->name('account-settlement-types.changestatus');
      Route::any('/changedefault', [AccountSettlementTypesController::class, 'changedefault'])->name('account-settlement-types.changedefault');
   });

   /**************************** Account Titles *********************************/
   Route::resource('account-titles', AccountTitlesController::class);
   Route::group(['prefix' => 'account-titles'], function () {
      Route::any('/delete', [AccountTitlesController::class, 'destroy'])->name('account-titles.destroy');
      Route::any('/changestatus', [AccountTitlesController::class, 'changeStatus'])->name('account-titles.changestatus');
   });

   /**************************** Address types *********************************/
   Route::resource('address-types', AddressTypesController::class);
   Route::any('address-types/delete', [AddressTypesController::class, 'destroy'])->name('address-types.destroy');
   Route::any('address-types/changestatus', [AddressTypesController::class, 'changestatus'])->name('address-types.changestatus');
   Route::any('address-types/changedefault', [AddressTypesController::class, 'changedefault'])->name('address-types.changedefault');

   /********************************** Marital Status ****************************************/
   Route::resource('blood-groups', BloodGroupsController::class);
   Route::any('blood-groups/delete', [BloodGroupsController::class, 'destroy'])->name('blood-groups.destroy');

   /********************************** Genders ****************************************/
   Route::resource('genders', GendersController::class);
   Route::any('genders/delete', [GendersController::class, 'destroy'])->name('genders.destroy');

   /********************************** Marital Status ****************************************/
   Route::resource('marital-statuses', MaritalStatusesController::class);
   Route::any('marital-statuses/delete', [MaritalStatusesController::class, 'destroy'])->name('marital-statuses.destroy');

   /**************************** License Types *********************************/
   Route::resource('license-types', LicenseTypesController::class);
   Route::group(['prefix' => 'license-types'], function () {
      Route::any('/delete', [LicenseTypesController::class, 'destroy'])->name('license-types.destroy');
      Route::any('/changestatus', [LicenseTypesController::class, 'changestatus'])->name('license-types.changestatus');
      Route::any('/changeIsMandatory', [LicenseTypesController::class, 'changeIsMandatory'])->name('license-types.changeIsMandatory');
      Route::any('/changeIsMandatory', [LicenseTypesController::class, 'changeIsMandatory'])->name('license-types.changeIsMandatory');
      Route::any('/changeShowPrint', [LicenseTypesController::class, 'changeShowPrint'])->name('license-types.changeShowPrint');
   });

   /**************************** Account Categories *********************************/
   Route::resource('account-categories', MasterCategoriesController::class);
   Route::group(['prefix' => 'account-categories'], function () {
      Route::any('/delete', [MasterCategoriesController::class, 'destroy'])->name('account-categories.destroy');
      Route::any('/changestatus', [MasterCategoriesController::class, 'changeStatus'])->name('account-categories.changestatus');
      Route::any('/changedefault', [MasterCategoriesController::class, 'changedefault'])->name('account-categories.changedefault');
   });

   /**************************** Account Types *********************************/
   Route::resource('account-types', MasterTypesController::class);
   Route::group(['prefix' => 'account-types'], function () {
      Route::any('/delete', [MasterTypesController::class, 'destroy'])->name('account-types.destroy');
      Route::any('/changestatus', [MasterTypesController::class, 'changeStatus'])->name('account-types.changestatus');
      Route::any('/changedefault', [MasterTypesController::class, 'changedefault'])->name('account-types.changedefault');
      Route::any('/changePerson', [MasterTypesController::class, 'changePerson'])->name('account-types.changeperson');
   });

   Route::get('/license-types-settings', [MasterTypesController::class, 'licenseTypesSettings'])->name('license-types-settings');
   Route::post('/license-types-settings', [MasterTypesController::class, 'licenseTypesSettingsPost'])->name('license-types-settings');
   Route::post('account-type-groups', [MasterTypesController::class, 'accountTypeGroups'])->name('account-type-groups');


   /**************************** Account Titles *********************************/
   Route::resource('tax-register-categories', TaxRegisterCategoriesController::class);
   Route::group(['prefix' => 'tax-register-categories'], function () {
      Route::any('/delete', [TaxRegisterCategoriesController::class, 'destroy'])->name('tax-register-categories.destroy');
      Route::any('/changestatus', [TaxRegisterCategoriesController::class, 'changeStatus'])->name('tax-register-categories.changestatus');
      Route::any('/changedefault', [TaxRegisterCategoriesController::class, 'changedefault'])->name('tax-register-categories.changedefault');
   });

   Route::group(['prefix' => 'accounts-import'], function () {
      Route::get('/export-sample', [TempAccountImportController::class, 'exportSample'])->name('accounts-import.export-sample');
      Route::any('/modal', [TempAccountImportController::class, 'importForm'])->name('accounts-import.modal');
      Route::any('/proceed', [TempAccountImportController::class, 'importAccounts'])->name('accounts-import.proceed');
      Route::any('/delete', [TempAccountImportController::class, 'destroy'])->name('accounts-import.delete');
      Route::get('/clear-data', [TempAccountImportController::class, 'clearData'])->name('accounts-import.clear-data');
   });
   Route::resource('accounts-import', TempAccountImportController::class);
   Route::any('account-import', [TempAccountImportController::class, 'accountImportCreate'])->name('account-import-create');


   Route::get('doctor-account-edit/{id}', [AccountsController::class, 'AccountsController.php@EditPatientDoctorDetails'])->name('doctor-account-edit');
   Route::post('doctor-account-update/{id}', [AccountsController::class, 'updateDoctorDetails'])->name('doctor-account-update');


   Route::get('collection-agent-account-edit/{id}', [AccountsController::class, 'EdiCollectionAgentDetails'])->name('collection-agent-account-edit');
   Route::post('collection-agent-account-update/{id}', [AccountsController::class, 'updateCollectionAgentDetails'])->name('collection-agent-account-update');

   Route::get('referral-agent-account-edit/{id}', [AccountsController::class, 'EdiReferralAgentDetails'])->name('referral-agent-account-edit');
   Route::post('referral-agent-account-update/{id}', [AccountsController::class, 'updateReferralAgentDetails'])->name('referral-agent-account-update');

   Route::get('patient-account-edit/{id}', [AccountsController::class, 'EditPatient'])->name('patient-account-edit');
   Route::post('patient-account-update/{id}', [AccountsController::class, 'UpdatePatient'])->name('patient-account-update');

Route::get('/trial-balance', [FinancialReportsController::class, 'trialBalance'])->name('trial-balance');
Route::get('/profit-and-loss', [FinancialReportsController::class, 'profitAndLoss'])->name('profitAndLoss');
Route::get('/balance-sheet', [FinancialReportsController::class, 'balanceSheet'])->name('balanceSheet');



