<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Accounting\PaymentVouchersController;
use App\Http\Controllers\Accounting\AccountingReceiptsController;
use App\Http\Controllers\Accounting\AccountingJournalsController;
use App\Http\Controllers\Accounting\ContraVouchersController;
use App\Http\Controllers\Accounting\AccountTransactionsController;
use App\Http\Controllers\Accounting\CashFlowStatementController;
use App\Http\Controllers\Accounting\ConsolidateStatementController;

   Route::get('payment-voucher-statement', [PaymentVouchersController::class, 'paymentVoucherStatement'])->name('payment-voucher-statement');
   Route::get('payment-voucher-statement-export', [PaymentVouchersController::class, 'exportStatement'])->name('payment-voucher-statement-export');
   /********************************** Finding-Categories ************************************/
   Route::any('payment-voucher-change-status', [PaymentVouchersController::class, 'changeStatus'])->name('payment-voucher.changestatus');
    Route::any('payment-voucher-submit', [PaymentVouchersController::class, 'receiptVoucherSubmit'])->name('payment-voucher-submit');
   Route::any('add-payment-vouchers', [PaymentVouchersController::class,'addReceiptVouchers'])->name('add-payment-vouchers');
   Route::post('payment-voucher-search-accounts', [PaymentVouchersController::class,'searchAccounts'])->name('payment-voucher-search-accounts');
   Route::any('payment-voucher-entries', [PaymentVouchersController::class,'receiptVoucherEntries'])->name('payment-voucher-entries');
   Route::any('payment-voucher-delete', [PaymentVouchersController::class, 'destroy'])->name('payment-voucher-delete');
   Route::any('payment-voucher-entry-remove', [PaymentVouchersController::class, 'receiptVoucherEntryRemove'])->name('payment-voucher-entry-remove');
    Route::any('edit-payment-voucher-entry-remove', [PaymentVouchersController::class, 'editReceiptVoucherEntryRemove'])->name('edit-payment-voucher-entry-remove');
    Route::resource('payment-voucher', PaymentVouchersController::class);
    Route::get('print-payment-voucher/{id}', [PaymentVouchersController::class, 'printPaymentVoucher'])->name('print-payment-voucher');

    Route::post('update-payment-vouchers/{id}', [PaymentVouchersController::class, 'update'])->name('update-payment-vouchers');
    Route::post('create-payment-vouchers/{id}', [PaymentVouchersController::class, 'receiptVoucherSubmit'])->name('create-payment-vouchers');

   /********************************** Finding-Categories ************************************/
   Route::any('receipt-voucher-change-status', [AccountingReceiptsController::class, 'changeStatus'])->name('receipt-voucher.changestatus');
    Route::any('receipt-voucher-submit', [AccountingReceiptsController::class, 'receiptVoucherSubmit'])->name('receipt-voucher-submit');
   Route::any('add-receipt-vouchers', [AccountingReceiptsController::class,'addReceiptVouchers'])->name('add-receipt-vouchers');
   Route::post('receipt-voucher-search-accounts', [AccountingReceiptsController::class,'searchAccounts'])->name('receipt-voucher-search-accounts');
   Route::any('receipt-voucher-entries', [AccountingReceiptsController::class,'receiptVoucherEntries'])->name('receipt-voucher-entries');
   Route::any('receipt-voucher-delete', [AccountingReceiptsController::class, 'destroy'])->name('receipt-voucher-delete');
   Route::any('receipt-voucher-entry-remove', [AccountingReceiptsController::class, 'receiptVoucherEntryRemove'])->name('receipt-voucher-entry-remove');
    Route::any('edit-receipt-voucher-entry-remove', [AccountingReceiptsController::class, 'editReceiptVoucherEntryRemove'])->name('edit-receipt-voucher-entry-remove');
    Route::resource('receipt-voucher', AccountingReceiptsController::class);
    Route::get('print-receipt-voucher/{id}', [AccountingReceiptsController::class, 'printReceiptVoucher'])->name('print-receipt-voucher');

    Route::post('update-receipt-vouchers/{id}', [AccountingReceiptsController::class, 'update'])->name('update-receipt-vouchers');
    Route::post('create-receipt-vouchers/{id}', [AccountingReceiptsController::class, 'receiptVoucherSubmit'])->name('create-receipt-vouchers');

    Route::get('receipt-voucher-statement', [AccountingReceiptsController::class, 'receiptVoucherStatement'])->name('receipt-voucher-statement');
    Route::get('receipt-voucher-statement-export', [AccountingReceiptsController::class, 'exportStatement'])->name('receipt-voucher-statement-export');
    
    Route::post('search-account', [AccountingReceiptsController::class, 'searchAccount'])->name('receipt-voucher-search-account');

   /******************************* Accounting Journals *****************************/
   Route::post('journal-voucher-search-accounts', [AccountingJournalsController::class, 'searchAccounts'])->name('journal-voucher-search-accounts');
   Route::any('add-journal-vouchers', [AccountingJournalsController::class, 'addJournalVouchers'])->name('add-journal-vouchers');
   Route::any('journal-voucher-entries', [AccountingJournalsController::class, 'journalVoucherEntries'])->name('journal-voucher-entries');
   Route::resource('accounting-journals', AccountingJournalsController::class);

    Route::get('journal-voucher-statement', [AccountingJournalsController::class, 'journalVoucherStatement'])->name('journal-voucher-statement');
    Route::get('journal-voucher-statement-export', [AccountingJournalsController::class, 'exportStatement'])->name('journal-voucher-statement-export');

     /******************************* Accounting Journals *****************************/
    Route::any('journal-voucher-change-status', [AccountingJournalsController::class, 'changeStatus'])->name('journal-voucher.changestatus');
    Route::any('journal-voucher-change-approval-status', [AccountingJournalsController::class, 'changeApprovalStatus'])->name('journal-voucher.change.approval.status');
    Route::post('journal-voucher-search-accounts', [AccountingJournalsController::class,'searchAccounts'])->name('journal-voucher-search-accounts');
    Route::any('edit-journal-vouchers', [AccountingJournalsController::class,'editJournalVouchers'])->name('edit-journal-vouchers');
    Route::any('add-journal-vouchers', [AccountingJournalsController::class,'addJournalVouchers'])->name('add-journal-vouchers');
    Route::any('edit-journal-voucher-entries', [AccountingJournalsController::class,'editJournalVoucherEntries'])->name('edit-journal-voucher-entries');
    Route::any('journal-voucher-entries', [AccountingJournalsController::class,'journalVoucherEntries'])->name('journal-voucher-entries');
    Route::any('journal-voucher-submit', [AccountingJournalsController::class, 'journalVoucherSubmit'])->name('journal-voucher-submit');
    Route::any('journal-voucher-update', [AccountingJournalsController::class, 'journalVoucherUpdate'])->name('journal-voucher-update');
    Route::post('journal-voucher-entry-update', [AccountingJournalsController::class, 'journalVoucherEntryUpdate'])->name('journal-voucher-entry-update');
    Route::any('journal-voucher-delete', [AccountingJournalsController::class, 'destroy'])->name('journal-voucher-delete');
    Route::any('journal-voucher-entry-remove', [AccountingJournalsController::class, 'journalVoucherEntryRemove'])->name('journal-voucher-entry-remove');
    Route::any('edit-journal-voucher-entry-remove', [AccountingJournalsController::class, 'editJournalVoucherEntryRemove'])->name('edit-journal-voucher-entry-remove');
    Route::resource('journal-voucher', AccountingJournalsController::class);
    Route::get('print-journal-voucher/{id}', [AccountingJournalsController::class, 'printJournalVoucher'])->name('print-journal-voucher');
    Route::post('edit-journal-voucher-entry-update', [AccountingJournalsController::class, 'editJournalVoucherEntryUpdate'])->name('edit-journal-voucher-entry-update');

   /******************************* Constra Voucher *****************************/
   Route::post('contra-voucher-search-accounts', [ContraVouchersController::class, 'searchAccounts'])->name('contra-voucher-search-accounts');

   Route::resource('contra-vouchers', ContraVouchersController::class);
    Route::any('contra-voucher-submit', [ContraVouchersController::class, 'contraVoucherSubmit'])->name('contra-voucher-submit');

    Route::any('contra-voucher-change-status', [ContraVouchersController::class, 'changeStatus'])->name('contra-voucher.changestatus');
    Route::any('contra-voucher-change-approval-status', [ContraVouchersController::class, 'changeApprovalStatus'])->name('contra-voucher.change.approval.status');
    Route::any('edit-contra-vouchers', [ContraVouchersController::class,'editContraVouchers'])->name('edit-contra-vouchers');
    Route::any('add-contra-vouchers', [ContraVouchersController::class,'addContraVouchers'])->name('add-contra-vouchers');
   Route::any('edit-contra-voucher-entries', [ContraVouchersController::class,'editContraVoucherEntries'])->name('edit-contra-voucher-entries');
   Route::any('contra-voucher-entries', [ContraVouchersController::class,'contraVoucherEntries'])->name('contra-voucher-entries');
    Route::any('contra-voucher-update', [ContraVouchersController::class, 'contraVoucherUpdate'])->name('contra-voucher-update');
    Route::any('contra-voucher-delete', [ContraVouchersController::class, 'destroy'])->name('contra-voucher-delete');
    Route::any('contra-voucher-entry-remove', [ContraVouchersController::class, 'contraVoucherEntryRemove'])->name('contra-voucher-entry-remove');
    Route::any('edit-contra-voucher-entry-remove', [ContraVouchersController::class, 'editContraVoucherEntryRemove'])->name('edit-contra-voucher-entry-remove');

    Route::get('print-contra-voucher/{id}', [ContraVouchersController::class, 'printContraVoucher'])->name('print-contra-voucher');

    Route::post('contra-voucher-entry-update', [ContraVouchersController::class, 'contraVoucherEntryUpdate'])->name('contra-voucher-entry-update');

    Route::post('edit-contra-voucher-entry-update', [ContraVouchersController::class, 'editContraVoucherEntryUpdate'])->name('edit-contra-voucher-entry-update');

    Route::get('contra-voucher-statement', [ContraVouchersController::class, 'contraVoucherStatement'])->name('contra-voucher-statement');
    Route::get('contra-voucher-statement-export', [ContraVouchersController::class, 'exportStatement'])->name('contra-voucher-statement-export');
   /********************************** Advance Settings ***********************************/
   Route::resource('all-transactions', AccountTransactionsController::class);
   Route::get('transactions-statement', [AccountTransactionsController::class, 'statement'])->name('transaction-statement');
   Route::get('transactions-statement-export', [AccountTransactionsController::class, 'exportStatement'])->name('transactions-statement-export');
   Route::resource('cash-flow-statement', CashFlowStatementController::class);
   Route::resource('consolidate-statement', ConsolidateStatementController::class);
