<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\SectionController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\Api\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login', [AuthController::class, 'signin']);
Route::post('register', [AuthController::class, 'signup']);
Route::middleware('auth:sanctum')->group( function () {
    Route::resource('section', SectionController::class);
});

Route::get('get-timezones', [ApiController::class, 'getTimezones']);
Route::get('get-currencies', [ApiController::class, 'getCurrencies']);
route::post('license-validation',[ApiController::class, 'licenseValidation']);

Route::middleware(['api.auth'])->prefix('v1')->group(function () {
	Route::post('meta-mint-api', [ApiController::class, 'metaMintAPI']);
	/*Route::post('get-account-list', [ApiController::class, 'getAccountList']);
	Route::post('get-report-list-for-linking', [ApiController::class, 'getReportListForLinking']);
	Route::post('get-test-invoice-data', [ApiController::class, 'getTestInvoiceData']);
	Route::post('save-test-care-context', [ApiController::class, 'saveTestCareContext']);
	Route::post('save-account-abha-address', [ApiController::class, 'saveAccountABHAAddress']);*/
});
