<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\APIManagement\ApisManagementController;
use App\Http\Controllers\APIManagement\EInvoiceSettingsController;
use App\Http\Controllers\APIManagement\EWayBillApiSettingsController;
use App\Http\Controllers\APIManagement\EmailApiController;
use App\Http\Controllers\APIManagement\SmsTemplateController;
use App\Http\Controllers\APIManagement\StorageSettingsController;
use App\Http\Controllers\APIManagement\SmsAPITemplateController;
use App\Http\Controllers\APIManagement\MetaMintAPIController;

    /********************** API Management ****************************/
    Route::resource('api-management', ApisManagementController::class);
    Route::group(['prefix' => 'api-management'], function () {
      Route::any('/changedefault', [ApisManagementController::class, 'changedefault'])->name('api-management.changedefault');
       Route::any('/delete', [ApisManagementController::class, 'destroy'])->name('api-management.delete');
    });

   /******************************* Sms Template Routes *************************************/
   Route::resource('smstemplate', SmsTemplateController::class);
   Route::group(['prefix' => 'smstemplate'], function () {
      Route::any('/changestatus', [SmsTemplateController::class, 'changestatus'])->name('smstemplate.changestatus');
      Route::any('/delete', [SmsTemplateController::class, 'destroy'])->name('smstemplate.destroy');

   });

   /********************************** Storage Settings ***********************************/
   Route::resource('storage-settings', StorageSettingsController::class);
   Route::any('storage-setting/delete', [StorageSettingsController::class, 'destroy'])->name('storage-setting.destroy');
   Route::any('storage-settings/changestatus', [StorageSettingsController::class, 'changestatus'])->name('storage-setting.changestatus');

   /********************************** E Invoice Settings ************************************/
   Route::resource('e-invoice-settings', EInvoiceSettingsController::class);
   Route::prefix('/e-invoice-settings/')->group(function () {
      Route::any('/delete', [EInvoiceSettingsController::class, 'destroy'])->name('e-invoice-settings.destroy');
      Route::any('/changedefault', [EInvoiceSettingsController::class, 'changedefault'])->name('e-invoice-settings.changedefault');
      Route::any('/change-status', [EInvoiceSettingsController::class, 'changeStatus'])->name('e-invoice-settings.changestatus');
   });
   /********************************** E Way Bill Api Settings ************************************/
   Route::resource('e-way-bill-api-settings', EWayBillApiSettingsController::class);
   Route::prefix('/e-way-bill-api-settings/')->group(function () {
      Route::any('/delete', [EWayBillApiSettingsController::class, 'destroy'])->name('e-way-bill-api-settings.destroy');
      Route::any('/changedefault', [EWayBillApiSettingsController::class, 'changedefault'])->name('e-way-bill-api-settings.changedefault');
      Route::any('/change-status', [EWayBillApiSettingsController::class, 'changeStatus'])->name('e-way-bill-api-settings.changestatus');
   });
   /********************************** E Mail API ************************************/
   Route::resource('e-mail-apis', EmailApiController::class);
   Route::prefix('/e-mail-apis/')->group(function () {
      Route::any('/delete', [EmailApiController::class, 'destroy'])->name('e-mail-apis.destroy');
      Route::any('/changedefault', [EmailApiController::class, 'changedefault'])->name('e-mail-apis.changedefault');
      Route::any('/change-status', [EmailApiController::class, 'changeStatus'])->name('e-mail-apis.changestatus');
   });
   Route::group(['prefix' => 'smsapitemplate'], function () {
      Route::any('/sms-api', [SmsAPITemplateController::class, 'smsapi'])->name('smsapitemplate.sms-api');
      Route::any('/updatesmsapi', [SmsAPITemplateController::class, 'updatesmsapi'])->name('smsapitemplate.updatesmsapi');
   });
   Route::resource('meta-mint-apis', MetaMintAPIController::class);
   Route::prefix('/meta-mint-apis/')->group(function () {
      Route::any('/delete', [MetaMintAPIController::class, 'destroy'])->name('meta-mint-apis.destroy');
      Route::any('/change-status', [MetaMintAPIController::class, 'changeStatus'])->name('meta-mint-apis.changestatus');
   });