<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\BookingController;

//booking
Route::resource('booking-register', BookingController::class);
Route::any('all-products-add-to-cart', [BookingController::class, 'allProductAddToCart'])->name('all-products-add-to-cart');
Route::any('sales', [BookingController::class, 'billings'])->name('sales');
Route::any('printbooking/{id}', [BookingController::class, 'bookingPrint'])->name('printbooking');
Route::any('bookingdetails-view-edit/{id}', [BookingController::class, 'bookingDetailsViewEdit'])->name('bookingdetails-view-edit');
Route::post('bookingdetails-view-update/{id}', [BookingController::class, 'bookingDetailsViewUpdate'])->name('bookingdetails-view-update');

// accounts
Route::any('/createconsignor', [BookingController::class, 'createConsignor'])->name('booking.createconsignor');
Route::any('/storeconsignor', [BookingController::class, 'storeConsignor'])->name('booking.storeconsignor');
Route::any('/editconsignor/{id}', [BookingController::class, 'editConsignor'])->name('booking.editconsignor');
Route::post('account-update/{id}', [BookingController::class, 'UpdateConsignor'])->name('account-update');

// product add to cart
Route::post('search-product', [BookingController::class, 'searchProduct'])->name('search-product');
Route::any('sale-products-cart/{invoice_id?}', [BookingController::class, 'productsCart'])->name('sale-products-cart');
Route::any('products-add-to-cart', [BookingController::class, 'productAddToCart'])->name('products-add-to-cart');
Route::any('cart-products-remove', [BookingController::class, 'cartProductsRemove'])->name('cart-products-remove');
Route::any('cart-product-update', [BookingController::class, 'cartProductsUpdate'])->name('cart-product-update');
Route::any('taxpaidby-update', [BookingController::class, 'taxPaidByUpdate'])->name('taxpaidby-update');
Route::any('products-cart', [BookingController::class, 'productCart'])->name('products-cart');

// additional Charges add to cart
Route::post('search-charge', [BookingController::class, 'searchCharge'])->name('search-charge');
Route::any('additional-charges-cart/{invoice_id?}', [BookingController::class, 'chargesCart'])->name('additional-charges-cart');
Route::any('charges-add-to-cart', [BookingController::class, 'chargeAddToCart'])->name('charges-add-to-cart');
Route::any('cart-charge-remove', [BookingController::class, 'cartChargeRemove'])->name('cart-charge-remove');
Route::any('cart-charge-update', [BookingController::class, 'cartChargeUpdate'])->name('cart-charge-update');
Route::any('taxpaid-update', [BookingController::class, 'taxPaidUpdate'])->name('taxpaid-update');
Route::any('charges-cart', [BookingController::class, 'chargeCart'])->name('charges-cart');

// Invoice  add to cart
Route::any('invoice-cart/{invoice_id?}', [BookingController::class, 'invoiceCart'])->name('invoice-cart');
Route::any('invoice-add-to-cart', [BookingController::class, 'invoiceAddToCart'])->name('invoice-add-to-cart');
Route::any('cart-invoice-remove', [BookingController::class, 'cartInvoiceRemove'])->name('cart-invoice-remove');
Route::any('invoices-cart', [BookingController::class, 'invoicesCart'])->name('invoices-cart');
// items 
Route::any('storeitem', [BookingController::class, 'storeitem'])->name('storeitem');
Route::any('item-delete', [BookingController::class, 'destroyitem'])->name('item-delete');
Route::any('edit-item/{id}', [BookingController::class, 'editItem'])->name('edit-item');
Route::post('item-update/{id}', [BookingController::class, 'updateitem'])->name('item-update');

  //charges
Route::any('storechange', [BookingController::class, 'storecharge'])->name('storecharge');
Route::any('charge-delete', [BookingController::class, 'destroycharge'])->name('charge-delete');
Route::any('edit-charge/{id}', [BookingController::class, 'editcharge'])->name('edit-charge');
Route::post('charge-update/{id}', [BookingController::class, 'updatecharge'])->name('charge-update');

  //invoices
Route::any('storeinvoice', [BookingController::class, 'storeinvoice'])->name('storeinvoice');
Route::any('invoice-delete', [BookingController::class, 'destroyinvoice'])->name('invoice-delete');
Route::any('edit-invoice/{id}', [BookingController::class, 'editinvoice'])->name('edit-invoice');
Route::post('invoice-update/{id}', [BookingController::class, 'updateinvoice'])->name('invoice-update');

//insurance
Route::any('edit-insurance/{id}', [BookingController::class, 'editInsurance'])->name('edit-insurance');
Route::post('update-insurance/{id}', [BookingController::class, 'updateInsurance'])->name('update-insurance');

//Container Details
Route::any('/Edit-container/{id}', [BookingController::class, 'editContainer'])->name('edit.container');
Route::post('/updatecontainer/{id}', [BookingController::class, 'updateContainer'])->name('updatecontainer');

//Pickup Address Details
Route::any('edit-pickup-address/{id}', [BookingController::class, 'editPickupAddress'])->name('edit-pickup-address');
Route::post('update-pickup-address/{id}', [BookingController::class, 'updatePickupAddress'])->name('update-pickup-address');

//Bill To Address Details
Route::any('edit-billto-address/{id}', [BookingController::class, 'editBilltoAddress'])->name('edit-billto-address');
Route::post('update-billto-address/{id}', [BookingController::class, 'updateBilltoAddress'])->name('update-billto-address');

//Ship To Address Details
Route::any('edit-shipto-address/{id}', [BookingController::class, 'editShiptoAddress'])->name('edit-shipto-address');
Route::post('update-shipto-address/{id}', [BookingController::class, 'updateShiptoAddress'])->name('update-shipto-address');

// Broker Details
Route::any('edit-broker_details/{id}', [BookingController::class, 'editBrokerDetails'])->name('edit-broker_details');
Route::post('update-broker_details/{id}', [BookingController::class, 'updateBrokerDetails'])->name('update-broker_details');

// accounts
Route::any('/createaccount', [BookingController::class, 'createaccount'])->name('booking.createaccount');
Route::any('/storeaccount', [BookingController::class, 'storeaccount'])->name('booking.storeaccount');
Route::any('/editaccount/{id}', [BookingController::class, 'editaccount'])->name('booking.editaccount');
Route::post('accountupdate/{id}', [BookingController::class, 'Updateaccount'])->name('accountupdate');
