<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Company\CompanyController;
use App\Http\Controllers\Company\CompanyLicenseController;
use App\Http\Controllers\Company\CompanyBanksController;
use App\Http\Controllers\Company\CompanyDocumentsController;
use App\Http\Controllers\Company\CompanyAddressesController;
use App\Http\Controllers\Company\CompanyEstablishmentTypesController;
use App\Http\Controllers\CompanyImagesController;

   /*
    * COMPANY START HERE
    */

   /**************************** Company Route*********************************/
   Route::resource('companies', CompanyController::class);
   Route::group(['prefix' => 'companies'], function () {
      Route::any('/changestatus', [CompanyController::class, 'changestatus'])->name('companies.changestatus');
      Route::any('/changedefault', [CompanyController::class, 'changedefault'])->name('companies.changedefault');
      Route::match(['GET', 'POST'], '/delete', [CompanyController::class, 'delete'])->name('companies.destroy');
      Route::match(['GET', 'POST'], '/add-license', [CompanyLicenseController::class, 'addLicense'])->name('companies.add.license');

      Route::any('/banks/{id}', [CompanyController::class, 'companyBanks'])->name('companies.banks');
      Route::any('/addresses/{id}', [CompanyController::class, 'addresses'])->name('companies.addresses');
      Route::any('/documents/{id}', [CompanyController::class, 'documents'])->name('companies.documents');
      Route::get('/upload-images/{id}', [CompanyController::class, 'selectImage'])->name('companies.upload_images');
      Route::post('/store-images', [CompanyController::class, 'storeImage'])->name('companies.store_images');
      Route::any('/company-images/{id}', [CompanyController::class, 'companyImage'])->name('companies.images');
   });

   /**************************** Company Banks *********************************/
   Route::resource('company-banks', CompanyBanksController::class);
   Route::group(['prefix' => 'company-banks'], function () {
      Route::any('/delete', [CompanyBanksController::class, 'destroy'])->name('company-banks.destroy');
      Route::any('/create-bank/{id}', [CompanyBanksController::class, 'create'])->name('company-banks.create_bank');
      Route::any('/changestatus', [CompanyBanksController::class, 'changestatus'])->name('company-banks.changestatus');
      Route::any('/changedefault', [CompanyBanksController::class, 'changedefault'])->name('company-banks.changedefault');
   });

   /**************************** Company Documents *********************************/
   Route::resource('company-documents', CompanyDocumentsController::class);
   Route::group(['prefix' => 'company-documents'], function () {
      Route::any('/delete', [CompanyDocumentsController::class, 'destroy'])->name('company-documents.destroy');
      Route::any('/create-documents/{id}', [CompanyDocumentsController::class, 'create'])->name('company-documents.create_document');
      Route::any('/changestatus', [CompanyDocumentsController::class, 'changestatus'])->name('company-documents.changestatus');
      Route::any('/changedefault', [CompanyDocumentsController::class, 'changedefault'])->name('company-documents.changedefault');
   });


   /**************************** Company Addresses *********************************/
   Route::resource('companies-addresses', CompanyAddressesController::class);
   Route::group(['prefix' => 'companies-addresses'], function () {
      Route::any('/delete', [CompanyAddressesController::class, 'destroy'])->name('companies-addresses.destroy');
      Route::any('/create-addresses/{id}', [CompanyAddressesController::class, 'createAddress'])->name('companies-addresses.create_address');
      Route::any('/changestatus', [CompanyAddressesController::class, 'changestatus'])->name('companies-addresses.changestatus');
      Route::any('/changedefault', [CompanyAddressesController::class, 'changedefault'])->name('companies-addresses.changedefault');
   });

   /**************************** Company License Route*********************************/
   Route::resource('license', CompanyLicenseController::class);
   Route::group(['prefix' => 'license'], function () {
      Route::any('/changestatus', [CompanyLicenseController::class, 'changestatus'])->name('license.changestatus');
      Route::any('/changeIsMandatory', [CompanyLicenseController::class, 'changeIsMandatory'])->name('license.changeIsMandatory');
      Route::any('/changeShowPrint', [CompanyLicenseController::class, 'changeShowPrint'])->name('license.changeShowPrint');
      Route::match(['GET', 'POST'], '/delete', [CompanyLicenseController::class, 'delete'])->name('license.destroy');
   });

   /**************************** Establishment Types *****************************/
   Route::resource('establishment-types', CompanyEstablishmentTypesController::class);
   Route::group(['prefix' => 'establishment-types'], function () {
      Route::any('/delete', [CompanyEstablishmentTypesController::class, 'destroy'])->name('establishment-types.destroy');
   });

   /**************************** Company Images *********************************/
   Route::resource('companies-images', CompanyImagesController::class);
   Route::group(['prefix' => 'companies-images'], function () {
      Route::any('/delete', [CompanyImagesController::class, 'destroy'])->name('companies-images.destroy');
      Route::any('/create-company-images/{id}', [CompanyImagesController::class, 'createImages'])->name('companies-images.create_images');
      Route::any('/changestatus', [CompanyImagesController::class, 'changestatus'])->name('companies-images.changestatus');
      Route::any('/changedefault', [CompanyImagesController::class, 'changedefault'])->name('companies-images.changedefault');
   });
