<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Enquiries\EnquiriesController;
use App\Http\Controllers\Enquiries\EnquiryCategoriesController;
use App\Http\Controllers\Enquiries\EnquiryTypesController;
use App\Http\Controllers\Enquiries\EnquirySourcesController;
use App\Http\Controllers\Enquiries\EnquiryQualitiesController;
use App\Http\Controllers\Enquiries\EnquiryStatusController;
use App\Http\Controllers\Enquiries\EnquiryCategoryExtraFieldsController;
use App\Http\Controllers\Enquiries\EnquiryContactsController;

   /*
    * ENQUIRY START HERE
    */

   /********************************** Enquiry Category Status ****************************************/
   Route::any('enquiry-category-fields/delete', [EnquiryCategoryExtraFieldsController::class, 'destroy'])->name('enquiry-category-fields.destroy');

   Route::group(['prefix' => 'enquiry-category-fields'], function () {
      Route::get('/{id}', [EnquiryCategoryExtraFieldsController::class, 'index'])->name('enquiry-category-fields.index');
      Route::get('/{id}/create', [EnquiryCategoryExtraFieldsController::class, 'create'])->name('enquiry-category-fields.create');
      Route::post('/{id}/store', [EnquiryCategoryExtraFieldsController::class, 'store'])->name('enquiry-category-fields.store');
      Route::get('/{id}/edit', [EnquiryCategoryExtraFieldsController::class, 'edit'])->name('enquiry-category-fields.edit');
      Route::any('/{id}/update', [EnquiryCategoryExtraFieldsController::class, 'update'])->name('enquiry-category-fields.update');
      Route::any('/{id}/get/{enquiry?}', [EnquiryCategoryExtraFieldsController::class, 'getFields'])->name('enquiry-category-fields.get');
      Route::any('/changemenditory', [EnquiryCategoryExtraFieldsController::class, 'changeMenditory'])->name('enquiry-category-fields.changemenditory');
      Route::any('/changereadonly', [EnquiryCategoryExtraFieldsController::class, 'changeReadonly'])->name('enquiry-category-fields.changereadonly');
      Route::any('/changestatus', [EnquiryCategoryExtraFieldsController::class, 'changeStatus'])->name('enquiry-category-fields.changestatus');
   });

   /********************************** Enquiries *********************************************/
   Route::resource('enquiries', EnquiriesController::class);
   Route::group(['prefix' => 'enquiries'], function () {
      Route::get('/list', [EnquiriesController::class, 'list']);
      Route::any('/delete', [EnquiriesController::class, 'destroy'])->name('enquiries.destroy');
      Route::any('/changestatus', [EnquiriesController::class, 'changeStatus'])->name('enquiries.changestatus');
      Route::any('/changedefault', [EnquiriesController::class, 'changedefault'])->name('enquiries.changedefault');
   });
   Route::any('attachment/delete', [EnquiriesController::class, 'destroyAttachment'])->name('attachment.destroy');

   /********************************** Enquiry Contacts *********************************************/
   Route::resource('enquiry-contacts', EnquiryContactsController::class);
   Route::any('enquiry-contacts/delete', [EnquiryContactsController::class, 'destroy'])->name('enquiry-contacts.destroy');
   Route::get('enquiry-contacts-model', [EnquiryContactsController::class, 'createModel'])->name('enquiry-contacts-model');
   Route::any('get-enquiry-contacts', [EnquiryContactsController::class, 'getContacts'])->name('get-enquiry-contacts');

   /********************************** Enquiry Category *********************************************/
   Route::resource('enquiry-categories', EnquiryCategoriesController::class);
   Route::group(['prefix' => 'enquiry-categories'], function () {
      Route::get('/list', [EnquiryCategoriesController::class, 'list']);
      Route::any('/delete', [EnquiryCategoriesController::class, 'destroy'])->name('enquiry-categories.destroy');
      Route::any('/changestatus', [EnquiryCategoriesController::class, 'changeStatus'])->name('enquiry-categories.changestatus');
      Route::any('/changedefault', [EnquiryCategoriesController::class, 'changedefault'])->name('enquiry-categories.changedefault');
   });

   /********************************** Enquiry Type *********************************************/
   Route::resource('enquiry-types', EnquiryTypesController::class);
   Route::group(['prefix' => 'enquiry-types'], function () {
      Route::get('/list', [EnquiryTypesController::class, 'list']);
      Route::any('/delete', [EnquiryTypesController::class, 'destroy'])->name('enquiry-types.destroy');
      Route::any('/changestatus', [EnquiryTypesController::class, 'changeStatus'])->name('enquiry-types.changestatus');
      Route::any('/changedefault', [EnquiryTypesController::class, 'changedefault'])->name('enquiry-types.changedefault');
   });

   /********************************** Enquiry Sources *********************************************/
   Route::resource('enquiry-sources', EnquirySourcesController::class);
   Route::group(['prefix' => 'enquiry-sources'], function () {
      Route::get('/list', [EnquirySourcesController::class, 'list']);
      Route::any('/delete', [EnquirySourcesController::class, 'destroy'])->name('enquiry-sources.destroy');
      Route::any('/changestatus', [EnquirySourcesController::class, 'changeStatus'])->name('enquiry-sources.changestatus');
      Route::any('/changedefault', [EnquirySourcesController::class, 'changedefault'])->name('enquiry-sources.changedefault');
   });

   /********************************** Enquiry Qualities *********************************************/
   Route::resource('enquiry-qualities', EnquiryQualitiesController::class);
   Route::group(['prefix' => 'enquiry-qualities'], function () {
      Route::get('/list', [EnquiryQualitiesController::class, 'list']);
      Route::any('/delete', [EnquiryQualitiesController::class, 'destroy'])->name('enquiry-qualities.destroy');
      Route::any('/changestatus', [EnquiryQualitiesController::class, 'changeStatus'])->name('enquiry-qualities.changestatus');
      Route::any('/changedefault', [EnquiryQualitiesController::class, 'changedefault'])->name('enquiry-qualities.changedefault');
   });

   /********************************** Enquiry Statuses *********************************************/
   Route::resource('enquiry-statuses', EnquiryStatusController::class);
   Route::group(['prefix' => 'enquiry-statuses'], function () {
      Route::get('/list', [EnquiryStatusController::class, 'list']);
      Route::any('/delete', [EnquiryStatusController::class, 'destroy'])->name('enquiry-statuses.destroy');
      Route::any('/changestatus', [EnquiryStatusController::class, 'changeStatus'])->name('enquiry-statuses.changestatus');
      Route::any('/changedefault', [EnquiryStatusController::class, 'changedefault'])->name('enquiry-statuses.changedefault');
      Route::any('/changehide', [EnquiryStatusController::class, 'changehide'])->name('enquiry-statuses.changehide');
   });
