<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HumanResource\EmployeesController;
use App\Http\Controllers\HumanResource\EmployeeTypesController;
use App\Http\Controllers\HumanResource\DesignationsController;

    /************************** employee  *******************************/
    Route::resource('employee', EmployeesController::class);
    Route::group(['prefix' => 'employee'], function () {
       Route::any('/delete', [EmployeesController::class, 'destroy'])->name('employee.destroy');
       Route::any('/changeStatus', [EmployeesController::class, 'changeStatus'])->name('employee.changestatus');
    });
    Route::any('/employee-import-create', [EmployeesController::class, 'employeeImportCreate'])->name('employee.import.create');
    Route::any('/employee-import', [EmployeesController::class, 'employeeImport'])->name('employee.import');

    /************************** Employee Type *******************************/
    Route::resource('employee-type', EmployeeTypesController::class);
    Route::group(['prefix' => 'employee-type'], function () {
       Route::any('/delete', [EmployeeTypesController::class, 'destroy'])->name('employee-type.destroy');
       Route::any('/changeStatus', [EmployeeTypesController::class, 'changeStatus'])->name('employee-type.changestatus');
    });

    /************************** Designation  *******************************/
    Route::resource('designation', DesignationsController::class);
    Route::group(['prefix' => 'designation'], function () {
       Route::any('/delete', [DesignationsController::class, 'destroy'])->name('designation.destroy');
       Route::any('/changeStatus', [DesignationsController::class, 'changeStatus'])->name('designation.changestatus');
    });