<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\IncentiveSlab\IncentiveSettingsController;
use App\Http\Controllers\IncentiveSlab\IncentiveSlabController;
use App\Http\Controllers\IncentiveSlab\IncentiveSlabDetailsController;
use App\Http\Controllers\IncentiveSlab\DrCommissionsController;

    /********************** Incentive Settings ****************************/
    Route::resource('incentive-settings', IncentiveSettingsController::class);
   Route::group(['prefix' => 'incentive-settings'], function () {
      Route::get('/list', [IncentiveSettingsController::class, 'list']);
      Route::any('/delete', [IncentiveSettingsController::class, 'destroy'])->name('incentive-settings.destroy');
      Route::any('/changestatus', [IncentiveSettingsController::class, 'changeStatus'])->name('incentive-settings.changestatus');
      Route::any('/changereceivedby', [IncentiveSettingsController::class, 'changeReceivedBy'])->name('incentive-settings.changereceivedby');
      //auto complete
      Route::any('/search', [IncentiveSettingsController::class, 'searchAccount'])->name('incentive-settings.searchAccount');
   });
   // Incentive Settings Export
   Route::any('/incentive_settings/export/create', [IncentiveSettingsController::class, 'exportCreate'])->name('incentive-settings-export-create');
   Route::any('/export/view', [IncentiveSettingsController::class, 'exportView'])->name('incentive-settings-export-view');
   Route::any('/export', [IncentiveSettingsController::class, 'export'])->name('incentive-settings.export');
    // Incentive Settings Import
    Route::any('incentive-settings/import', [IncentiveSettingsController::class, 'import'])->name('incentive-settings.import');

    /********************** Incentive Slab ****************************/
    Route::resource('incentive-slabs', IncentiveSlabController::class);
   Route::group(['prefix' => 'incentive-slabs'], function () {
      Route::get('/list', [IncentiveSlabController::class, 'list']);
      Route::any('/delete', [IncentiveSlabController::class, 'destroy'])->name('incentive-slabs.destroy');
      Route::any('/changestatus', [IncentiveSlabController::class, 'changeStatus'])->name('incentive-slabs.changestatus');
      Route::any('/changedefault', [IncentiveSlabController::class, 'changedefault'])->name('incentive-slabs.changedefault');
      Route::get('/details/{id}', [IncentiveSlabController::class, 'details'])->name('incentive-slabs.details');
      Route::post('/store-details/{id}', [IncentiveSlabController::class, 'storeDetails'])->name('incentive-slabs.store-details');
   });
    /********************** Incentive Slab Details ****************************/
    Route::resource('incentive-slab-details', IncentiveSlabDetailsController::class);
   Route::group(['prefix' => 'incentive-slab-details'], function () {
      Route::get('/list', [IncentiveSlabDetailsController::class, 'list']);
      Route::any('/delete', [IncentiveSlabDetailsController::class, 'destroy'])->name('incentive-slab-details.destroy');
      Route::any('/changestatus', [IncentiveSlabDetailsController::class, 'changeStatus'])->name('incentive-slab-details.changestatus');
    //   Route::any('/changedefault', [IncentiveSlabDetailsController::class, 'changedefault'])->name('incentive-slab-details.changedefault');
   });
   // Incentive Slab Details Export
   Route::any('/incentive-slab-details-export-create/{id?}', [IncentiveSlabDetailsController::class, 'incentiveSlabDetailsExportCreate'])->name('incentive-slab-details-export-create');
   Route::any('incentive-slab-details-export-view', [IncentiveSlabDetailsController::class, 'incentiveSlabDetailsExportView'])->name('incentive-slab-details-export-view');
   Route::any('incentive-slab-details-export', [IncentiveSlabDetailsController::class, 'incentiveSlabDetailExport'])->name('incentive-slab-details-export');
    // Incentive Slab Details Import
    Route::any('incentive-slab-details-import', [IncentiveSlabDetailsController::class,'incentiveSlabDetailImport'])->name('incentive-slab-details-import');
    Route::any('incentive-slab-details-import', [IncentiveSlabDetailsController::class,'incentiveSlabDetailImport'])->name('incentive-slab-details-import');

    Route::get('dr-referral-list-generate/{id?}', [DrCommissionsController::class,'generate'])->name('dr-referral-list-generate');
    Route::get('dr-referral-list-store/{id?}', [DrCommissionsController::class,'generate'])->name('dr-referral-list-store');