<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LabBilling\LabBillingsController;

   /******************************* Lab Billings *****************************/
   Route::post('billings-search-patients', [LabBillingsController::class, 'searchPatients'])->name('billings-search-patients');
   Route::post('billings-search-doctors', [LabBillingsController::class, 'searchDoctors'])->name('billings-search-doctors');
   Route::post('billings-search-referral', [LabBillingsController::class, 'searchReferrals'])->name('billings-search-referral');
   Route::post('billings-search-collection', [LabBillingsController::class, 'searchCollectionLabs'])->name('billings-search-collection');
   Route::post('billings-search-product', [LabBillingsController::class, 'searchProducts'])->name('billings-search-product');
   Route::resource('lab-billings', LabBillingsController::class);
   Route::any('lab-billings/delete', [LabBillingsController::class, 'destroy'])->name('lab-billings.destroy');


   Route::any('remove-sub-details/{id}}', [LabBillingsController::class, 'subDetailsDelete'])->name('remove-sub-details');


   Route::any('billing-product-cart/{invoice_id?}', [LabBillingsController::class, 'productCart'])->name('billing-product-cart');
   Route::any('products-add-to-cart', [LabBillingsController::class, 'productAddToCart'])->name('products-add-to-cart');
   Route::any('cart-product-remove', [LabBillingsController::class, 'cartProductRemove'])->name('cart-product-remove');
   Route::any('cart-product-update', [LabBillingsController::class, 'cartProductUpdate'])->name('cart-product-update');
   Route::get('cart-billing', [LabBillingsController::class, 'billing'])->name('cart-billing');
   Route::get('pathology-invoice/{id}', [LabBillingsController::class, 'pathologyInvoice'])->name('pathology-invoice');
   Route::get('billing-report/{invoice_id}', [LabBillingsController::class, 'billingReport'])->name('billing-report');
   Route::post('billing-report/{invoice_id}', [LabBillingsController::class, 'billingReportStore'])->name('billing-report.store');
   Route::post('billing-report-departments', [LabBillingsController::class, 'billingReportDepartment'])->name('billing-report-departments');
   Route::get('print-billing-report/{invoice_id}', [LabBillingsController::class, 'billingReportPrint'])->name('print-billing-report');
   Route::get('print-test-packages-status/{invoice_id}', [LabBillingsController::class, 'printTestPackagesStatus'])->name('print-test-packages-status');
   Route::get('billing-report-logs/{invoice_id}', [LabBillingsController::class, 'billingReportLog'])->name('billing-report-logs');
   Route::get('sticker-billing-report/{id}', [LabBillingsController::class, 'billingReportSticker'])->name('sticker-billing-report');

   Route::get('billings-edit-patient/{invoice_id}', [LabBillingsController::class, 'editPatients'])->name('billings-edit-patient');
   Route::post('billings-update-patient/{invoice_id}', [LabBillingsController::class, 'updatePatient'])->name('billings-update-patient');

   Route::get('billings-edit-doctor/{invoice_id}', [LabBillingsController::class, 'editDoctor'])->name('billings-edit-doctor');
   Route::post('billings-update-doctor/{invoice_id}', [LabBillingsController::class, 'updateDoctor'])->name('billings-update-doctor');

   Route::get('billings-edit-agent/{invoice_id}', [LabBillingsController::class, 'editCollectionAgent'])->name('billings-edit-agent');
   Route::post('billings-update-agent/{invoice_id}', [LabBillingsController::class, 'updateCollectionAgent'])->name('billings-update-agent');

   Route::get('billings-edit-referral-lab/{invoice_id}', [LabBillingsController::class, 'editReferralLab'])->name('billings-edit-referral-lab');
   Route::post('billings-update-referral-lab/{invoice_id}', [LabBillingsController::class, 'updateReferralLab'])->name('billings-update-referral-lab');

   Route::get('edit-cart-billing/{invoice_id}', [LabBillingsController::class, 'editBilling'])->name('edit-cart-billing');
   Route::get('pathology-billing-collection/{invoice_id}', [LabBillingsController::class, 'pathologyCollection'])->name('pathology-billing-collection');

   //  Route::post('update-lab-billing-vouchers/{id}', [LabBillingsController::class, 'pathologyCollectionUpdate'])->name('update-lab-billing-vouchers');
   //  Route::post('create-lab-billing-vouchers/{id}', [LabBillingsController::class, 'pathologyCollectionCreate'])->name('create-lab-billing-vouchers');

   Route::any('lab-billing-reports', [LabBillingsController::class, 'statement'])->name('lab-billing-reports');
   Route::any('lab-billing-reports-export', [LabBillingsController::class, 'exportStatement'])->name('lab-billing-reports-export');

   Route::get('pathology-invoice-refresh/{id}', [LabBillingsController::class, 'invoiceRefresh'])->name('pathology-invoice-refresh');
   Route::post('test-item-options', [LabBillingsController::class, 'searchItemOptions'])->name('test-item-options');