<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LabBilling\LabBillingReportsController;

    Route::any('/lab-reporting', [LabBillingReportsController::class, 'labReporting'])->name('lab-reporting');
    Route::any('/lab-reporting-dashboard', [LabBillingReportsController::class, 'dashboard'])->name('lab-reporting-dashboard');

    Route::any('/sample-collections', [LabBillingReportsController::class, 'sampleCollection'])->name('sample-collections');
    Route::any('/sample-collection-status', [LabBillingReportsController::class, 'sampleCollectionStatus'])->name('sample-collection-status');

    Route::any('/result-update', [LabBillingReportsController::class, 'resultUpdate'])->name('result-update');

    Route::get('/doctor-reviews', [LabBillingReportsController::class, 'doctorReview'])->name('doctor-reviews');
   	Route::get('doctor-review/{invoice_id}', [LabBillingReportsController::class, 'review'])->name('doctor-review');

   	Route::post('doctor-review/{invoice_id}', [LabBillingReportsController::class, 'reviewReportStore'])->name('doctor-review.store');
   	Route::post('report-reupdate/{invoice_id}', [LabBillingReportsController::class, 'reportReupdate'])->name('report-reupdate');

    Route::get('/old-lab-reports', [LabBillingReportsController::class, 'oldLabReport'])->name('old-lab-report');