<?php

use App\Http\Controllers\Library\BookIssueController;
use App\Http\Controllers\Library\BookOpeningStockController;
use App\Http\Controllers\Library\BookRequestController;
use App\Http\Controllers\Library\BookReturnIssueController;
use App\Http\Controllers\Library\BooksOpenApiController;
use App\Http\Controllers\Library\LibraryCardController;
use App\Http\Controllers\LibrarySetting\BookClassController;
use App\Http\Controllers\LibrarySetting\BookFormatesController;

use App\Http\Controllers\LibrarySetting\CardTypeController;
use App\Http\Controllers\LibrarySetting\EditorController;

use App\Http\Controllers\LibrarySetting\LibrarianAuthorsController;

use App\Http\Controllers\LibrarySetting\LibrarianGenresController;
use App\Http\Controllers\LibrarySetting\LibrarianPublishersController;
use App\Http\Controllers\LibrarySetting\LibrarianTagsController;

use App\Http\Controllers\LibrarySetting\MembershipPlanController;
use App\Http\Controllers\LibrarySetting\PlacesController;

use App\Http\Controllers\LibrarySetting\StreamController;

use App\Http\Controllers\LibrarySetting\TranslatorController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'library'], function () {

    /*************************************** Genres Route  *****************************/
    Route::resource('genres', LibrarianGenresController::class);
    Route::group(['prefix' => 'genres'], function () {
        Route::any('/changestatus', [LibrarianGenresController::class, 'changeStatus'])->name('library.genres.changestatus');

        Route::any('/import/create', [LibrarianGenresController::class, 'importcreate'])->name('library.category.import');
        Route::any('/import/preview', [LibrarianGenresController::class, 'importPreview'])->name('library.category.import-preview');
        Route::any('/import/session/delete', [LibrarianGenresController::class, 'importSessionDestroy'])->name('library.category.import-session-destroy');
        Route::any('/store/import', [LibrarianGenresController::class, 'importStore'])->name('library.category.import-store');
        Route::any('/export/format', [LibrarianGenresController::class, 'exportFormat'])->name('library.category.export-format');

        Route::any('/changeisfeatured', [LibrarianGenresController::class, 'changeisfeatured'])->name('library.genres.changeisfeatured');
        Route::any('/changewebsiteview', [LibrarianGenresController::class, 'changewebsiteview'])->name('library.genres.changewebsiteview');
        Route::any('/delete', [LibrarianGenresController::class, 'delete'])->name('library.genres.destroy');
    });

    /*************************************** Authors Route  *****************************/
    Route::resource('authors', LibrarianAuthorsController::class);
    Route::group(['prefix' => 'authors'], function () {
        Route::any('/changestatus', [LibrarianAuthorsController::class, 'changestatus'])->name('library.authors.changestatus');
        Route::any('/changeisfeatured', [LibrarianAuthorsController::class, 'changeisfeatured'])->name('library.authors.changeisfeatured');
        Route::any('/changewebsiteview', [LibrarianAuthorsController::class, 'changewebsiteview'])->name('library.authors.changewebsiteview');
        Route::any('/delete', [LibrarianAuthorsController::class, 'delete'])->name('library.authors.destroy');
        // Import Export
        Route::any('/import/create', [LibrarianAuthorsController::class, 'importcreate'])->name('library.authors.import');
        Route::any('/import/preview', [LibrarianAuthorsController::class, 'importPreview'])->name('library.authors.import-preview');
        Route::any('/import/session/delete', [LibrarianAuthorsController::class, 'importSessionDestroy'])->name('library.authors.import-session-destroy');
        Route::any('/store/import', [LibrarianAuthorsController::class, 'importStore'])->name('library.authors.import-store');
        Route::any('/export/format', [LibrarianAuthorsController::class, 'exportFormat'])->name('library.authors.export-format');
    });
    /*************************************** Publishers Route  *****************************/
    Route::resource('publishers', LibrarianPublishersController::class);
    Route::group(['prefix' => 'publishers'], function () {
        Route::any('/changestatus', [LibrarianPublishersController::class, 'changestatus'])->name('library.publishers.changestatus');
        Route::any('/changeisfeatured', [LibrarianPublishersController::class, 'changeisfeatured'])->name('library.publishers.changeisfeatured');
        Route::any('/changewebsiteview', [LibrarianPublishersController::class, 'changewebsiteview'])->name('library.publishers.changewebsiteview');
        Route::match(['GET', 'POST'], '/delete', [LibrarianPublishersController::class, 'delete'])->name('library.publishers.destroy');

        // Import Export
        Route::any('/import/create', [LibrarianPublishersController::class, 'importcreate'])->name('library.publishers.import');
        Route::any('/import/preview', [LibrarianPublishersController::class, 'importPreview'])->name('library.publishers.import-preview');
        Route::any('/import/session/delete', [LibrarianPublishersController::class, 'importSessionDestroy'])->name('library.publishers.import-session-destroy');
        Route::any('/store/import', [LibrarianPublishersController::class, 'importStore'])->name('library.publishers.import-store');
        Route::any('/export/format', [LibrarianPublishersController::class, 'exportFormat'])->name('library.publishers.export-format');
    });



    /*************************************** Tags Route  *****************************/
    Route::resource('library-tags', LibrarianTagsController::class);
    Route::group(['prefix' => 'library-tags'], function () {
        Route::any('/changestatus', [LibrarianTagsController::class, 'changestatus'])->name('library.library-tags.changestatus');
        Route::any('/delete', [LibrarianTagsController::class, 'delete'])->name('library.library-tags.destroy');
    });

    /*************************************** Tags Route  *****************************/
    Route::resource('places', PlacesController::class);
    Route::group(['prefix' => 'places'], function () {
        Route::any('/changestatus', [PlacesController::class, 'changestatus'])->name('library.places.changestatus');
        Route::any('/delete', [PlacesController::class, 'delete'])->name('library.places.destroy');
    });

    /*************************************** Editor Route  *****************************/
    Route::resource('editors', EditorController::class);
    Route::group(['prefix' => 'editors'], function () {
        Route::any('/changestatus', [EditorController::class, 'changestatus'])->name('library.editors.changestatus');
        Route::any('/delete', [EditorController::class, 'delete'])->name('library.editors.destroy');
        // Import Export
        Route::any('/import/create', [EditorController::class, 'importcreate'])->name('library.editors.import');
        Route::any('/import/preview', [EditorController::class, 'importPreview'])->name('library.editors.import-preview');
        Route::any('/import/session/delete', [EditorController::class, 'importSessionDestroy'])->name('library.editors.import-session-destroy');
        Route::any('/store/import', [EditorController::class, 'importStore'])->name('library.editors.import-store');
        Route::any('/export/format', [EditorController::class, 'exportFormat'])->name('library.editors.export-format');
    });

    /*************************************** Translator Route  *****************************/
    Route::resource('translators', TranslatorController::class);
    Route::group(['prefix' => 'translators'], function () {
        Route::any('/changestatus', [TranslatorController::class, 'changestatus'])->name('library.translators.changestatus');
        Route::any('/delete', [TranslatorController::class, 'delete'])->name('library.translators.destroy');

        // Import Export
        Route::any('/import/create', [TranslatorController::class, 'importcreate'])->name('library.translators.import');
        Route::any('/import/preview', [TranslatorController::class, 'importPreview'])->name('library.translators.import-preview');
        Route::any('/import/session/delete', [TranslatorController::class, 'importSessionDestroy'])->name('library.translators.import-session-destroy');
        Route::any('/store/import', [TranslatorController::class, 'importStore'])->name('library.translators.import-store');
        Route::any('/export/format', [TranslatorController::class, 'exportFormat'])->name('library.translators.export-format');
    });

    /*************************************** Book Formate Route  *****************************/
    Route::resource('book_formats', BookFormatesController::class);
    Route::group(['prefix' => 'book_formats'], function () {
        Route::any('/changestatus', [BookFormatesController::class, 'changestatus'])->name('library.book_formats.changestatus');
        Route::any('/delete', [BookFormatesController::class, 'delete'])->name('library.book_formats.destroy');
    });

    /*************************************** Book Classes Route  *****************************/
    Route::resource('book_classes', BookClassController::class);
    Route::group(['prefix' => 'book_classes'], function () {
        Route::any('/changestatus', [BookClassController::class, 'changestatus'])->name('library.book_classes.changestatus');
        Route::any('/delete', [BookClassController::class, 'delete'])->name('library.book_classes.destroy');
    });

    /*************************************** Stream Route  *****************************/
    Route::resource('stream', StreamController::class);
    Route::group(['prefix' => 'stream'], function () {
        Route::any('/changestatus', [StreamController::class, 'changestatus'])->name('library.stream.changestatus');
        Route::any('/changeisfeatured', [StreamController::class, 'changeisfeatured'])->name('library.stream.changeisfeatured');
        Route::any('/changewebsiteview', [StreamController::class, 'changewebsiteview'])->name('library.stream.changewebsiteview');
        Route::match(['GET', 'POST'], '/delete', [StreamController::class, 'delete'])->name('library.stream.destroy');
    });


    /********************************* Card Type************************************/
    Route::resource('card-type', CardTypeController::class);
    Route::group(['prefix' => 'card-type'], function () {
        Route::match(['GET', 'POST'], '/delete', [CardTypeController::class, 'delete'])->name('library.card-type.destroy');
        Route::any('/changestatus', [CardTypeController::class, 'changestatus'])->name('library.card-type.changestatus');
    });
    /********************************* Membership Plan************************************/
    Route::resource('membership-plan', MembershipPlanController::class);
    Route::group(['prefix' => 'membership-plan'], function () {
        Route::any('/changestatus', [MembershipPlanController::class, 'changestatus'])->name('membership-plan.changestatus');
        Route::match(['GET', 'POST'], '/delete', [MembershipPlanController::class, 'delete'])->name('library.membership-plan.destroy');
    });
});

Route::resource('book-issue', BookIssueController::class);
Route::group(['prefix' => 'book-issue'], function () {
    Route::match(['GET', 'POST'], '/delete', [BookIssueController::class, 'delete'])->name('library.book-issue.destroy');
    Route::match(['GET', 'POST'], '/add-issue-cart', [BookIssueController::class, 'addtoissuecart'])->name('add.to.issue.cart');
    Route::get('/book-return/issue-book-Cart', [BookIssueController::class, 'getcartissues'])->name('getissueCart');
    Route::get('/book-return/issue-book-Cart-update', [BookIssueController::class, 'getcartissuesupdate'])->name('getcartissuesupdate');
    Route::post('/book-return/issue-cart-book-remove', [BookIssueController::class, 'removecartissues'])->name('issue-cart-book-remove');
    Route::get('/book-issue/studentssearch', [BookIssueController::class, 'studentssearch'])->name('autocomplete.studentssearch');
    Route::get('/book-issue/bookssearch', [BookIssueController::class, 'bookssearch'])->name('autocomplete.bookssearch');
    Route::get('/book-issue/checkmembership', [BookIssueController::class, 'checkmembership'])->name('check-membership');
    Route::post('/deletebookitem', [BookIssueController::class, 'deletebookitem'])->name('deletebookitem');
    Route::match(['GET', 'POST'], '/print/{id}', [BookIssueController::class, 'print'])->name('book-issue.print');
});

Route::resource('book-return', BookReturnIssueController::class);
Route::group(['prefix' => 'book-return'], function () {
    Route::match(['GET', 'POST'], '/returnBooksearch', [BookReturnIssueController::class, 'returnBooksearch'])->name('return.returnBooksearch');
    Route::get('book-return/editget', [BookReturnIssueController::class, 'editget'])->name('return-book.fetchcart');
    Route::post('/deleteitem', [BookReturnIssueController::class, 'deletebookitem'])->name('delete-return-book-item');
    Route::match(['GET', 'POST'], '/deletes', [BookReturnIssueController::class, 'deletebook'])->name('book-return.delete');
    Route::match(['GET', 'POST'], '/print/{id}', [BookReturnIssueController::class, 'print'])->name('book-returns.print');
    Route::match(['GET', 'POST'], '/returnBookdamage', [BookReturnIssueController::class, 'addToCartDamage'])->name('return.damage.book.cart');
});

/****************Library Card **********************/
Route::resource('cards', LibraryCardController::class);
Route::group(['prefix' => 'cards'], function () {
    Route::match(['GET', 'POST'], '/getstudents', [LibraryCardController::class, 'GetStudents'])->name('cards.getstudent');
    Route::match(['GET', 'POST'], '/downloads/{id}', [LibraryCardController::class, 'downloads'])->name('cards.downloads');
    Route::match(['GET', 'POST'], '/changestatus', [LibraryCardController::class, 'changestatus'])->name('cards.changestatus');
});

/****************************Book Request List **********************/
Route::resource('book-request', BookRequestController::class);
Route::group(['prefix' => 'book-request'], function () {
    Route::match(['GET', 'POST'], '/store-status', [BookRequestController::class, 'storestatus'])->name('book-request.store-status');
    Route::match(['GET', 'POST'], '/create/{id?}', [BookRequestController::class, 'creates'])->name('book-request.creates');
    Route::match(['GET', 'POST'], '/book-request/getcart', [BookRequestController::class, 'getcartrequest'])->name('getcartrequest');
    Route::match(['GET', 'POST'], '/add-to-request-cart', [BookRequestController::class, 'addtorequestcart'])->name('add.to.request.cart');
    Route::match(['GET', 'POST'], '/cart-request-remove', [BookRequestController::class, 'removeRequestCart'])->name('cart-request-remove');
    Route::match(['GET', 'POST'], '/delete', [BookRequestController::class, 'delete'])->name('book-request.delete');
});
// Open Library Api Call Route
Route::get('/bulk', [BooksOpenApiController::class, 'openApi'])->name('library.books-openApi.add');
Route::get('/bookssearchopenapi', [BooksOpenApiController::class, 'bookssearchopenapi'])->name('autocomplete.booksearchopenpai');
// Route::post('/booksstoreopenapi', [BookIssueController::class,'booksstoreopenapi'])->name('book-openapi.store');
Route::match(['GET', 'POST'], '/book-bulk-store', [BooksOpenApiController::class, 'bulkstore'])->name('store-book.bulk');
Route::match(['GET', 'POST'], '/book-bulk-store-ajax', [BooksOpenApiController::class, 'bulkstoreajax'])->name('store-book-ajax.bulk');
Route::match(['GET', 'POST'], '/book-bulk-list', [BooksOpenApiController::class, 'bulklist'])->name('book-bulk-list');
Route::match(['GET', 'POST'], '/book-bulk-list-edit/{id}', [BooksOpenApiController::class, 'edit'])->name('book-bulk-list-edit');
Route::any('/book-bulk-list-update/{id}', [BooksOpenApiController::class, 'update'])->name('book-bulk-list-update');

Route::any('/check_error', [BooksOpenApiController::class, 'check_error'])->name('check_error');
Route::match(['GET', 'POST'], '/book-bulk-final-store', [BooksOpenApiController::class, 'bulktobook'])->name('bulktobook');
Route::any('/delete-book-temp', [BooksOpenApiController::class, 'deleteBookTempItem'])->name('library.books.temp.destroy');

// Opening Stock  Route
Route::get('/books-opening-stock', [BookOpeningStockController::class, 'openingStock'])->name('books-opening-stock.add');
Route::get('/export-opening-stocks-list', [BookOpeningStockController::class, 'exportbookstock'])->name('export.book-stock-list');
Route::post('/import-opening-stocks-list', [BookOpeningStockController::class, 'importbookstock'])->name('import.book-stock-list');
