<?php

use App\Http\Controllers\IndustryTypesController;
use App\Http\Controllers\LicenseManagement\PlanAndPackageContoller;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LicenseManagement\BilingIntervalsController;
use App\Http\Controllers\LicenseManagement\customerListController;
use App\Http\Controllers\LicenseManagement\ClientLicenseController;
use App\Http\Controllers\LicenseManagement\ClientLicenseDetailsController;
use App\Http\Controllers\LicenseManagement\UserLicenseDetailsController;
use App\Http\Controllers\LicenseManagement\LicenseDetailsController;
use App\Http\Controllers\LicenseManagement\LicenseRegisteredController;
use App\Http\Controllers\LicenseManagement\ServersController;
use App\Http\Controllers\LicenseManagement\PlaneAndPackageContoller;
use App\Http\Controllers\LicenseManagement\LicenseAuthenticationsController;


   /**************************** License Details *********************************/
   Route::resource('license-details', LicenseDetailsController::class);
   Route::group(['prefix' => 'license-details'], function () {
      Route::any('/delete', [LicenseDetailsController::class, 'destroy'])->name('license-details.destroy');
      Route::any('/changeStatus', [LicenseDetailsController::class, 'changeStatus'])->name('license-details.changeStatus');
      Route::any('/changeMaintenanceMode', [LicenseDetailsController::class, 'changeMaintenanceMode'])->name('license-details.changeMaintenanceMode');
   });
   Route::any('/license-activation-history/{id}', [LicenseDetailsController::class, 'activationHistory'])->name('license-activation-history');
   Route::get('license-registered-details/{id}', [LicenseDetailsController::class, 'index'])->name('license-registered-details');
   Route::get('license-details/create/{id?}', [LicenseDetailsController::class, 'create'])->name('license-details.create');
   Route::get('license-dashboard', [LicenseRegisteredController::class, 'dashboard'])->name('license.dashboard');
   Route::get('revenue-report/{type}', [LicenseRegisteredController::class, 'revenueReport'])->name('revenue.report');
   Route::get('renewal-report/{type}', [LicenseRegisteredController::class, 'renewalReport'])->name('renewal.report');
   Route::get('license-report/{type}', [LicenseRegisteredController::class, 'licenseReport'])->name('license.report');
   Route::get('service-report/{type}', [LicenseRegisteredController::class, 'serviceReport'])->name('service.report');
   // Export
   Route::get('export/renewal-report', [LicenseRegisteredController::class, 'exportRenewalReport'])->name('renewal.report.export');
   Route::get('export/revenue-report', [LicenseRegisteredController::class, 'exportRevenueReport'])->name('revenue.report.export');
   Route::get('export/license-report', [LicenseRegisteredController::class, 'exportLicenseReport'])->name('license.report.export');
   Route::get('export/service-report', [LicenseRegisteredController::class, 'exportServiceReport'])->name('service.report.export');
   Route::get('export/client-report', [LicenseRegisteredController::class, 'exportClientReport'])->name('client.report.export');
   Route::post('search/customer/select', [LicenseRegisteredController::class, 'customerSelect'])->name('customer.search-select');


   /********************** User License validity ****************************/
   Route::resource('user-license-validity', ClientLicenseDetailsController::class);
   Route::prefix('/user-license-validity/')->group(function () {
       Route::any('/delete',[ClientLicenseDetailsController::class,'destroy'])->name('user-license-validity.destroy');
       Route::any('/change-status',[ClientLicenseDetailsController::class,'changeStatus'])->name('user-license-validity.changestatus');
       Route::any('/payment-status',[ClientLicenseDetailsController::class,'paymentStatus'])->name('user-license-validity.paymentstatus');
   });

   /********************** User License  ****************************/
   Route::resource('user-license', ClientLicenseController::class);
   Route::prefix('/user-license/')->group(function () {
       Route::any('/delete',[ClientLicenseController::class,'destroy'])->name('user-license.destroy');
       Route::any('/change-status',[ClientLicenseController::class,'changeStatus'])->name('user-license.changestatus');
   });

   Route::get('license-registered/get-license', [LicenseRegisteredController::class, 'generateLicenseNumber'])->name('license-registered.get-license');
   Route::resource('license-register', LicenseRegisteredController::class);
   Route::any('license-registered/status', [LicenseRegisteredController::class, 'changeStatus'])->name('license-registered.changeStatus');
   Route::any('license-registered-keys/{id}', [LicenseRegisteredController::class, 'licenseKeys'])->name('license-registered-keys');

    /************************** Server *******************************/
    Route::resource('server', ServersController::class);
    Route::group(['prefix' => 'server'], function () {
       Route::any('/delete', [ServersController::class, 'destroy'])->name('server.destroy');
       Route::any('/changeStatus', [ServersController::class, 'changeStatus'])->name('server.changestatus');
       Route::any('/changedefault', [ServersController::class, 'changedefault'])->name('server.changedefault');
    });
    /************************** Biling Interval *******************************/
    Route::resource('biling-interval', BilingIntervalsController::class);
    Route::group(['prefix' => 'biling-interval'], function () {
       Route::any('/delete', [BilingIntervalsController::class, 'destroy'])->name('biling-interval.destroy');
       Route::any('/changeStatus', [BilingIntervalsController::class, 'changeStatus'])->name('biling-interval.changestatus');
    });

   /********************************** Customer list ************************************/
   Route::resource('customer-list', customerListController::class);
   Route::prefix('/customer-list/')->group(function () {
   });

    /************************** Plane And Packages *******************************/
    Route::resource('plan-and-packages', PlanAndPackageContoller::class);
    Route::group(['prefix' => 'plan-and-packages'], function () {
       Route::any('/delete', [PlanAndPackageContoller::class, 'destroy'])->name('plan-and-packages.destroy');
       Route::any('/changeStatus', [PlanAndPackageContoller::class, 'changeStatus'])->name('plan-and-packages.changestatus');
    });

    /********************** Plane Modules ****************************/
    Route::any('/plan-module-mapping/{id}/{code?}',[PlanAndPackageContoller::class,'planModuleMapping'])->name('plan-module-mapping');
    Route::get('plan-module-map/{id}', [PlanAndPackageContoller::class, 'planModuleMappingCreate'])->name('plan-module-map');
    // Route::post('add-all-modules', [PlanAndPackageContoller::class, 'addAllModules'])->name('all-modules.store');
    Route::get('plan-module-map-selected', [PlanAndPackageContoller::class, 'getSelectedModules'])->name('plan-module-mapping.selected');
    Route::post('plan-module-map-store/{id}', [PlanAndPackageContoller::class, 'storeSelectedModules'])->name('plan-module-mapping.store');
    Route::delete('destroy-plan-module-mapping', [PlanAndPackageContoller::class, 'removePlanModuleMapping'])->name('plan-module-mapping.destroy');
    Route::post('plan-module-status', [PlanAndPackageContoller::class, 'changeStatusPlanModuleMapping'])->name('plan-module-mapping.changestatus');

    Route::any('/plan-child-module-mapping/{id}/{parent_id}',[PlanAndPackageContoller::class,'planChildModuleMapping'])->name('plan-child-module-mapping');

    /********************** Plane Product ****************************/
    Route::any('/plan-product-mapping/{id}/{code?}',[PlanAndPackageContoller::class,'planProductMapping'])->name('plan-product-mapping');
    Route::get('plan-product-map/{id}', [PlanAndPackageContoller::class, 'planProductMappingCreate'])->name('plan-product-map');
    Route::post('add-all-products', [PlanAndPackageContoller::class, 'addAllProducts'])->name('all-products.store');
    Route::get('plan-product-map-selected', [PlanAndPackageContoller::class, 'getSelectedProducts'])->name('plan-product-mapping.selected');
    Route::post('plan-product-map-store/{id}', [PlanAndPackageContoller::class, 'storeSelectedProducts'])->name('plan-product-mapping.store');
    Route::delete('destroy-plan-product-mapping', [PlanAndPackageContoller::class, 'removePlanProductMapping'])->name('plan-product-mapping.destroy');
    Route::post('plan-product-status', [PlanAndPackageContoller::class, 'changeStatusPlanProductMapping'])->name('plan-product-mapping.changestatus');

    /************************** Industury  Type *******************************/
    Route::resource('industry-type', IndustryTypesController::class);
    Route::group(['prefix' => 'industry-type'], function () {
       Route::any('/delete', [IndustryTypesController::class, 'destroy'])->name('industry-type.destroy');
       Route::any('/changeStatus', [IndustryTypesController::class, 'changeStatus'])->name('industry-type.changestatus');
       Route::any('/changedefault', [IndustryTypesController::class, 'changeDefault'])->name('industry-type.changedefault');
    });


    /************************** Industury  Type *******************************/
    Route::resource('license-authentications', LicenseAuthenticationsController::class);
    Route::group(['prefix' => 'license-authentications'], function () {
       Route::any('/delete', [LicenseAuthenticationsController::class, 'destroy'])->name('license-authentications.destroy');
       Route::any('/changeStatus', [LicenseAuthenticationsController::class, 'changeStatus'])->name('license-authentications.changestatus');
       Route::any('/changedefault', [LicenseAuthenticationsController::class, 'changeDefault'])->name('license-authentications.changedefault');
    });
