<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Marketing\BusinessCategoriesController;
use App\Http\Controllers\Marketing\MarketingController;


   /********************************** Marketing ************************************/
   Route::resource('marketing', MarketingController::class);
   Route::prefix('/marketing/')->group(function () {
      Route::any('/delete', [MarketingController::class, 'destroy'])->name('marketing.destroy');
      Route::any('/change-status', [MarketingController::class, 'changeStatus'])->name('marketing.changestatus');
   });
   // market import
   Route::any('/market-create', [MarketingController::class, 'marketCreate'])->name('market.create');
   Route::any('/market-import', [MarketingController::class, 'marketImport'])->name('market.import');
   Route::any('/download-sample-file-marketing', [MarketingController::class, 'downloadSampleFile'])->name('download.sample');

   /********************************** Business Category ************************************/
   Route::resource('business-categories', BusinessCategoriesController::class);
   Route::prefix('/business-categories/')->group(function () {
      Route::any('/delete', [BusinessCategoriesController::class, 'destroy'])->name('business-categories.destroy');
      Route::any('/change-status', [BusinessCategoriesController::class, 'changeStatus'])->name('business-categories.changestatus');
   });