<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MedicalSetting\SymptomsController;
use App\Http\Controllers\MedicalSetting\SymptomClassificationsController;
use App\Http\Controllers\MedicalSetting\DischargeTypesController;
use App\Http\Controllers\MedicalSetting\FindingsController;
use App\Http\Controllers\MedicalSetting\FindingCategoriesController;
use App\Http\Controllers\MedicalSetting\OperationsController;
use App\Http\Controllers\MedicalSetting\OperationCategoriesController;
use App\Http\Controllers\MedicalSetting\BodyVitalsController;
use App\Http\Controllers\MedicalSetting\AnesthesiaTypesController;

   /*
    * MEDICAL-SETTINGS START HERE
    */
   /********************************** Symptoms ************************************/
   Route::resource('symptoms', SymptomsController::class);
   Route::prefix('/symptoms/')->group(function () {
      Route::any('/delete', [SymptomsController::class, 'destroy'])->name('symptoms.destroy');
      Route::any('/change-status', [SymptomsController::class, 'changeStatus'])->name('symptoms.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/create', [SymptomsController::class, 'importCreate'])->name('symptoms.import-create');
      Route::any('/import/preview', [SymptomsController::class, 'importPreview'])->name('symptoms.import-preview');
      Route::any('/store/import', [SymptomsController::class, 'importStore'])->name('symptoms.import-store');
      Route::any('/import/session/delete', [SymptomsController::class, 'importSessionDestroy'])->name('symptoms.import-session-destroy');
   });

   /********************************** Symptom-Classifications ************************************/
   Route::resource('symptom-classifications', SymptomClassificationsController::class);
   Route::prefix('/symptom-classifications/')->group(function () {
      Route::any('/delete', [SymptomClassificationsController::class, 'destroy'])->name('symptom-classifications.destroy');
      Route::any('/change-status', [SymptomClassificationsController::class, 'changeStatus'])->name('symptom-classifications.changestatus');
   });

   /********************************** Symptom-Classifications ************************************/
   Route::resource('discharge-types', DischargeTypesController::class);
   Route::prefix('/discharge-types/')->group(function () {
      Route::any('/delete', [DischargeTypesController::class, 'destroy'])->name('discharge-types.destroy');
      Route::any('/change-isdefault', [DischargeTypesController::class, 'isDefault'])->name('discharge-types.isdefault');
      Route::any('/change-status', [DischargeTypesController::class, 'changeStatus'])->name('discharge-types.changestatus');
   });

   /********************************** Findings ************************************/
   Route::resource('findings', FindingsController::class);
   Route::prefix('/findings/')->group(function () {
      Route::any('/delete', [FindingsController::class, 'destroy'])->name('findings.destroy');
      Route::any('/change-status', [FindingsController::class, 'changeStatus'])->name('findings.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/create', [FindingsController::class, 'importCreate'])->name('findings.import-create');
      Route::any('/import/preview', [FindingsController::class, 'importPreview'])->name('findings.import-preview');
      Route::any('/store/import', [FindingsController::class, 'importStore'])->name('findings.import-store');
      Route::any('/import/session/delete', [FindingsController::class, 'importSessionDestroy'])->name('findings.import-session-destroy');
   });


   /********************************** Finding-Categories ************************************/
   Route::resource('finding-categories', FindingCategoriesController::class);
   Route::prefix('/finding-categories/')->group(function () {
      Route::any('/delete', [FindingCategoriesController::class, 'destroy'])->name('finding-categories.destroy');
      Route::any('/change-status', [FindingCategoriesController::class, 'changeStatus'])->name('finding-categories.changestatus');
   });

   /********************************** Operations ************************************/
   Route::resource('operations', OperationsController::class);
   Route::prefix('/operations/')->group(function () {
      Route::any('/delete', [OperationsController::class, 'destroy'])->name('operations.destroy');
      Route::any('/change-status', [OperationsController::class, 'changeStatus'])->name('operations.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/create', [OperationsController::class, 'importCreate'])->name('operations.import-create');
      Route::any('/import/preview', [OperationsController::class, 'importPreview'])->name('operations.import-preview');
      Route::any('/store/import', [OperationsController::class, 'importStore'])->name('operations.import-store');
      Route::any('/import/session/delete', [OperationsController::class, 'importSessionDestroy'])->name('operations.import-session-destroy');
   });

   /********************************** Operation-Categories ************************************/
   Route::resource('operation-categories', OperationCategoriesController::class);
   Route::prefix('/operation-categories/')->group(function () {
      Route::any('/delete', [OperationCategoriesController::class, 'destroy'])->name('operation-categories.destroy');
      Route::any('/change-status', [OperationCategoriesController::class, 'changeStatus'])->name('operation-categories.changestatus');
   });

   /********************************** body-vitals ************************************/
   Route::resource('body-vitals', BodyVitalsController::class);
   Route::prefix('/body-vitals/')->group(function () {
      Route::any('/delete', [BodyVitalsController::class, 'destroy'])->name('body-vitals.destroy');
      Route::any('/change-status', [BodyVitalsController::class, 'changeStatus'])->name('body-vitals.changestatus');
      Route::any('/change-mandatory-status', [BodyVitalsController::class, 'changeMandatoryStatus'])->name('body-vitals.changemandatorystatus');
   });

   /********************************** anesthesia-types ************************************/
   Route::resource('anesthesia-types', AnesthesiaTypesController::class);
   Route::prefix('/anesthesia-types/')->group(function () {
      Route::any('/delete', [AnesthesiaTypesController::class, 'destroy'])->name('anesthesia-types.destroy');
      Route::any('/change-status', [AnesthesiaTypesController::class, 'changeStatus'])->name('anesthesia-types.changestatus');
      Route::any('/changedefault', [AnesthesiaTypesController::class, 'changedefault'])->name('anesthesia-types.changedefault');
   });