<?php
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\OpdAppointment\AppointmentDoctorScheduleController;
use App\Http\Controllers\OpdAppointment\AppointmentShiftController;
use App\Http\Controllers\OpdAppointment\AppointmentDoctorShiftsController;
use App\Http\Controllers\OpdAppointment\AppointmentDoctorShiftDays;
use App\Http\Controllers\OpdAppointment\AppointmentDoctorShiftDaysController;
use App\Http\Controllers\OpdAppointment\AppointmentDoctorFeesController;
use App\Http\Controllers\OpdAppointment\DoctorFeeController;
use App\Http\Controllers\OpdAppointment\DoctorHolidaySettingController;
use App\Http\Controllers\OpdAppointment\DoctorControllers;
use App\Http\Controllers\OpdAppointment\OPDScheduleTypeController;
use App\Http\Controllers\OpdAppointment\OpdBookingController;
use App\Http\Controllers\OpdAppointment\AppointmentController;
use App\Http\Controllers\OpdAppointment\DoctorChamberControllers;
use App\Http\Controllers\OpdAppointment\OpdPrescriptionImageController;

   /************************** Doctor *******************************/
   Route::resource('doctor', DoctorControllers::class);
   Route::group(['prefix' => 'doctor'], function () {
      Route::any('/delete', [DoctorControllers::class, 'destroy'])->name('doctor.destroy');
      Route::any('/changeStatus', [DoctorControllers::class, 'changeStatus'])->name('doctor.changestatus');
      Route::any('/changedefault', [DoctorControllers::class, 'changedefault'])->name('doctor.changedefault');

      Route::any('/web-booking-status', [DoctorControllers::class, 'WebBookingStatus'])->name('doctor.web-booking-status');
      Route::any('/app-booking-status', [DoctorControllers::class, 'AppBookingStatus'])->name('doctor.app-booking-status');
   });
   /**adding doctor with ID  **/
   Route::get('doctor-schedule/{id}', [DoctorControllers::class, 'addDoctorSchedule'])->name('add-doctor-schedule');
   /**Shift with ID  **/
   Route::get('shift/{id}', [DoctorControllers::class, 'addDoctorShift'])->name('add-doctor-shift');
   Route::get('getAccounts', [DoctorControllers::class, 'getAccounts'])->name('get-Accounts');
   /************************** Appointment Doctor Schedule  *******************************/
   Route::resource('appointment-doctor-schedule', AppointmentDoctorScheduleController::class);
   Route::group(['prefix' => 'appointment-doctor-schedule'], function () {
      Route::any('/delete', [AppointmentDoctorScheduleController::class, 'destroy'])->name('appointment-doctor-schedule.destroy');
      Route::any('/changeStatus', [AppointmentDoctorScheduleController::class, 'changeStatus'])->name('appointment-doctor-schedule.changestatus');
      Route::any('/changedefault', [AppointmentDoctorScheduleController::class, 'changedefault'])->name('appointment-doctor-schedule.changedefault');
   });
   Route::post('appointment-doctor-schedule-search-doctors', [AppointmentDoctorScheduleController::class, 'searchDoctors'])->name('appointment-doctor-schedule-search-doctors');
   /************************** Add days  *******************************/
   Route::get('add-days', [AppointmentDoctorScheduleController::class, 'addDays'])->name('add-days');
   Route::post('store-days', [AppointmentDoctorScheduleController::class, 'storeDays'])->name('store-days');
   Route::get('updateDays', [AppointmentDoctorScheduleController::class, 'updateDays'])->name('updateDays');
   Route::get('get-appointment-schedule', [AppointmentDoctorScheduleController::class, 'getAppointmentSchedule'])->name('get-appointment-schedule');


   /************************** Appointment Shift  *******************************/
   Route::resource('appointment-shift', AppointmentShiftController::class);
   Route::group(['prefix' => 'appointment-shift'], function () {
      Route::any('/delete', [AppointmentShiftController::class, 'destroy'])->name('appointment-shift.destroy');
      Route::any('/changeStatus', [AppointmentShiftController::class, 'changeStatus'])->name('appointment-shift.changestatus');
      Route::any('/changedefault', [AppointmentShiftController::class, 'changedefault'])->name('appointment-shift.changedefault');
   });
   /**************************  Doctor Fee old *******************************/
   Route::resource('doctor-fee', DoctorFeeController::class);
   Route::group(['prefix' => 'doctor-fee'], function () {
      Route::any('/delete', [DoctorFeeController::class, 'destroy'])->name('doctor-fee.destroy');
      Route::any('/changeStatus', [DoctorFeeController::class, 'changeStatus'])->name('doctor-fee.changestatus');
      Route::any('/changedefault', [DoctorFeeController::class, 'changedefault'])->name('doctor-fee.changedefault');
   });
   Route::post('doctor-fee-search-doctors', [DoctorFeeController::class, 'searchDoctors'])->name('doctor-fee-search-doctors');

   /************************** OPD Schedule Appointment *******************************/
   Route::resource('opd-schedule-type', OPDScheduleTypeController::class);
   Route::group(['prefix' => 'opd-schedule-type'], function () {
      Route::any('/delete', [OPDScheduleTypeController::class, 'destroy'])->name('opd-schedule-type.destroy');
      Route::any('/changeStatus', [OPDScheduleTypeController::class, 'changeStatus'])->name('opd-schedule-type.changestatus');
      Route::any('/changedefault', [OPDScheduleTypeController::class, 'changedefault'])->name('opd-schedule-type.changedefault');
   });

    /************************** Server *******************************/
    Route::resource('opd-bookings', OpdBookingController::class);
    Route::group(['prefix' => 'opd-bookings'], function () {
       Route::any('/delete', [OpdBookingController::class, 'destroy'])->name('opd-bookings.destroy');
       Route::any('/changeStatus', [OpdBookingController::class, 'changeStatus'])->name('opd-bookings.changestatus');
       Route::any('/doctors-list', [OpdBookingController::class, 'doctorList'])->name('opd-bookings.doctor-List');

       Route::any('opd-bookings/billing-product-cart/{id?}', [OpdBookingController::class, 'productCart'])->name('opd-bookings.billing-product-cart');
       Route::any('products-add-to-cart', [OpdBookingController::class, 'productAddToCart'])->name('opd-bookings.products-add-to-cart');
       Route::any('opd-bookings/cart-product-remove', [OpdBookingController::class, 'cartProductRemove'])->name('opd-bookings.cart-product-remove');
       Route::any('opd-bookings/cart-product-update', [OpdBookingController::class, 'cartProductUpdate'])->name('opd-bookings.cart-product-update');
       Route::get('cart-billing', [OpdBookingController::class, 'billing'])->name('opd-bookings.cart-billing');
       Route::post('billings-search-product', [OpdBookingController::class, 'searchProducts'])->name('opd-bookings.billings-search-product');

       Route::get('opd-bookings/edit-cart-billing/{invoice_id}', [OpdBookingController::class, 'editBilling'])->name('opd-bookings.edit-cart-billing');
       Route::get('/convert/{invoice_id?}/{booking_type?}', [OpdBookingController::class, 'convert'])->name('opd-bookings.convert');
       Route::any('opd-bookings/billing-product-convert/{id?}/{booking_type?}', [OpdBookingController::class, 'productConvert'])->name('opd-bookings.billing-product-convert');
       Route::any('billing-convert/{id?}/{booking_type?}', [OpdBookingController::class, 'ConvertBilling'])->name('opd-bookings.covert-cart-billing');

       Route::get('opd-invoice/{id}', [OpdBookingController::class, 'invoice'])->name('opd-bookings.invoice');
       Route::any('appointment-convert/{id?}/{booking_type?}', [OpdBookingController::class, 'AppointmentConvert'])->name('opd-bookings.appointmentConvert');

       Route::get('opd-slip/{id}', [OpdBookingController::class, 'opdSlip'])->name('opd-bookings.slip');

       Route::any('update/{id?}', [OpdBookingController::class, 'update'])->name('opd-bookings.update');

       Route::any('reschedule/{id?}', [OpdBookingController::class, 'reschedule'])->name('opd-bookings.reschedule');

       Route::any('reschedule-confirm/{doctor_id}/{shift_id}/{time}/{date}/{block_no}/{booking_id}', [OpdBookingController::class, 'rescheduleConfirm'])->name('opd-bookings.reschedule-confirm');
       

    });
    Route::any('opd-booking-doctors-list/{booking_type?}', [OpdBookingController::class, 'doctorList'])->name('opd-bookings.doctor-List');
    // Route::match(['get', 'post'], 'opd-booking-doctors-list', [OpdBookingController::class, 'doctorList'])->name('opd-bookings.doctor-List');
    Route::any('make/appointment/{id}/{booking_type?}', [OpdBookingController::class, 'makeAppointment'])->name('make.appointment');
    Route::any('doctor-appointment-days/{id?}', [OpdBookingController::class, 'doctorAppointmentDays'])->name('doctor.appointment.days');
    Route::any('appointment/form/{doctor_id}/{shift_id}/{time}/{date}/{block_no}/{booking_type?}', [OpdBookingController::class, 'appointmentFOrm'])->name('appointment.form');
    Route::any('appointment/billing/', [OpdBookingController::class, 'billing'])->name('appointment.billing');
    Route::post('appointment-form/submit', [OpdBookingController::class, 'appointmentsave'])->name('appointment.save');



    /*********************  Doctor Holiday Setting  ************************/
   Route::group(['prefix' => 'doctor-holiday-shifts'], function () {
      Route::any('/{id}', [DoctorHolidaySettingController::class, 'index'])->name('doctor-holiday-shifts.index');
      Route::any('/create/{id}', [DoctorHolidaySettingController::class, 'create'])->name('doctor-holiday-shifts.create');
      Route::any('/{id}/store', [DoctorHolidaySettingController::class, 'store'])->name('doctor-holiday-shifts.store');
      Route::any('/{id}/edit', [DoctorHolidaySettingController::class, 'edit'])->name('doctor-holiday-shifts.edit');
      Route::any('/{id}/update', [DoctorHolidaySettingController::class, 'update'])->name('doctor-holiday-shifts.update');
      Route::any('/delete/{doctor_id}', [DoctorHolidaySettingController::class, 'destroy'])->name('doctor-holiday-shifts.destroy');
   });

   /*********************  Doctor Shifts  ************************/
   Route::group(['prefix' => 'appointment-doctor-shifts'], function () {
      Route::any('/{id}', [AppointmentDoctorShiftsController::class, 'index'])->name('appointment-doctor-shifts.index');
      Route::any('/edit/{id}', [AppointmentDoctorShiftsController::class, 'edit'])->name('appointment-doctor-shifts.edit');
      Route::any('/update/{id}', [AppointmentDoctorShiftsController::class, 'update'])->name('appointment-doctor-shifts.update');
      Route::any('/{id}/store', [AppointmentDoctorShiftsController::class, 'store'])->name('appointment-doctor-shifts.store');
   });
   Route::any('/doctor-shift-status', [AppointmentDoctorShiftsController::class, 'shiftStatus'])->name('appointment-doctor-shifts.doctor-shift-status');
   Route::any('/doctor-shift-web-booking-status', [AppointmentDoctorShiftsController::class, 'shiftWebBookingStatus'])->name('appointment-doctor-shifts.doctor-shift-web-booking-status');
   Route::any('/doctor-shift-app-booking-status', [AppointmentDoctorShiftsController::class, 'shiftAppBookingStatus'])->name('appointment-doctor-shifts.doctor-shift-app-booking-status');

   /*********************  Doctor Days  ************************/
   Route::group(['prefix' => 'appointment-doctor-shift-days'], function () {
      Route::any('/{doctor_id}/{shift_id}', [AppointmentDoctorShiftDaysController::class, 'index'])->name('appointment-doctor-shift-days.index');
      Route::any('/{doctor_id}/{shift_id}/store', [AppointmentDoctorShiftDaysController::class, 'store'])->name('appointment-doctor-shift-days.store');
      Route::any('/status-active', [AppointmentDoctorShiftDaysController::class, 'statusActive'])->name('appointment-doctor-shift-days.status-active');
   });
   /*********************  Doctor Fees  ************************/
   Route::group(['prefix' => 'appointment-doctor-fees'], function () {
      Route::any('/{doctor_id}/{shift_id}', [AppointmentDoctorFeesController::class, 'index'])->name('appointment-doctor-fees.index');
      Route::get('/create', [AppointmentDoctorFeesController::class, 'create'])->name('appointment-doctor-fees.create');
      Route::any('/store', [AppointmentDoctorFeesController::class, 'store'])->name('appointment-doctor-fees.store');
      Route::any('/delete', [AppointmentDoctorFeesController::class, 'destroy'])->name('doctor-fee-products.destroy');
      Route::any('/changestatus', [AppointmentDoctorFeesController::class, 'changestatus'])->name('doctor-fee-products.changestatus');
      Route::post('doctor-fee-search-products', [AppointmentDoctorFeesController::class, 'searchProduct'])->name('doctor-fee-search-products');
   });
   Route::get('appointment-doctor-fees-edit/{id}', [AppointmentDoctorFeesController::class, 'edit'])->name('appointment-doctor-fees-edit');
   Route::any('appointment-doctor-fees-update/{id}', [AppointmentDoctorFeesController::class, 'update'])->name('appointment-doctor-fees-update');

   Route::get('opd-appointment', [AppointmentController::class, 'index'])->name('opd-appointment.index');
   Route::any('opd-booking-reports', [AppointmentController::class, 'reports'])->name('opd-bookings.reports');
   Route::any('opd-statement-export', [AppointmentController::class, 'exportStatement'])->name('opd-statement-export');
   Route::any('patient-head-print/{id}', [AppointmentController::class, 'patientHeadPrint'])->name('opd-bookings.patient-head-print');
   Route::any('opd-appointment/prescription-print/{id}', [AppointmentController::class, 'prescriptionPrint'])->name('opd-bookings.prescription-print');
   Route::get('opd-appointment/view/{id}', [AppointmentController::class, 'show'])->name('opd-appointment.show');
   Route::get('opd-appointment/{id}/edit/', [AppointmentController::class, 'edit'])->name('opd-appointment.edit');
   Route::any('opd-appointment/delete', [AppointmentController::class, 'destroy'])->name('opd-appointment.destroy');

   Route::get('appointment-edit-patient/{id}', [AppointmentController::class, 'editPatients'])->name('appointment.edit-patient');
   Route::post('appointment-update-patient/{id}', [AppointmentController::class, 'updatePatient'])->name('appointment.update-patient');

   Route::get('appointment-edit-doctor/{id}', [AppointmentController::class, 'editDoctor'])->name('appointment-edit-doctor');
   Route::post('appointment-update-doctor/{id}', [AppointmentController::class, 'updateDoctor'])->name('appointment-update-doctor');

   Route::get('appointment-edit-agent/{id}', [AppointmentController::class, 'editCollectionAgent'])->name('appointment-edit-agent');
   Route::post('appointment-update-agent/{id}', [AppointmentController::class, 'updateCollectionAgent'])->name('appointment-update-agent');

   Route::get('appointment-edit-referral-lab/{id}', [AppointmentController::class, 'editReferralLab'])->name('appointment-edit-referral-lab');
   Route::post('appointment-update-referral-lab/{id}', [AppointmentController::class, 'updateReferralLab'])->name('appointment-update-referral-lab');

   Route::any('opd-appointment/delete', [AppointmentController::class, 'destroy'])->name('opd-appointment.destroy');
   Route::any('opd-appointment/checkIn', [AppointmentController::class, 'checkIn'])->name('opd-appointment.checkIn');

   Route::any('doctor/prescription/{id}', [OpdPrescriptionImageController::class, 'index'])->name('doctor-prescription.index');
   Route::any('doctor/prescription/create/{id}', [OpdPrescriptionImageController::class, 'create'])->name('doctor-prescription.create');
   Route::any('doctor/prescription/edit/{id}', [OpdPrescriptionImageController::class, 'edit'])->name('doctor-prescription.edit');
   Route::post('doctor/prescription/store/{id}', [OpdPrescriptionImageController::class, 'store'])->name('doctor-prescription.store');
   Route::any('doctor/prescription/update/{id}', [OpdPrescriptionImageController::class, 'update'])->name('doctor-prescription.update');
   Route::any('doctor/prescription/delete/{id}', [OpdPrescriptionImageController::class, 'destroy'])->name('doctor-prescription.delete');
   Route::any('doctor/prescription/changestatus/{id}', [OpdPrescriptionImageController::class, 'changestatus'])->name('doctor-prescription.changestatus');
   /***************** Doctor Chamber Route *********************/
   Route::resource('doctor-chamber',DoctorChamberControllers::class);
   Route::group(['prefix' => 'doctor-chamber'], function () {
   Route::any('changestatus', [DoctorChamberControllers::class, 'changestatus'])->name('doctor-chamber.changestatus');
   Route::any('changedefault', [DoctorChamberControllers::class, 'changeDefault'])->name('doctor-chamber.changeDefault');
   Route::any('/delete', [DoctorChamberControllers::class, 'destroy'])->name('doctor-chamber.destroy');
   });



