<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Product\ProductsController;
use App\Http\Controllers\Product\ProductAlternativeUnitsController;
use App\Http\Controllers\Product\ProductAttributeTypesController;
use App\Http\Controllers\Product\ProductAttributesController;
use App\Http\Controllers\Product\ProductBrandsController;
use App\Http\Controllers\Product\ProductCategoriesController;
use App\Http\Controllers\Product\ProductGroupsController;
use App\Http\Controllers\Product\ProductItemTypesController;
use App\Http\Controllers\Product\ProductLocationRackController;
use App\Http\Controllers\Product\ProductWarehouseController;
use App\Http\Controllers\Product\ProductPricesController;
use App\Http\Controllers\Product\BusinessDivisionController;
use App\Http\Controllers\Product\ProductTestPackagesController;
use App\Http\Controllers\Product\PrimaryUnitController;
use App\Http\Controllers\Product\ProductBatchController;
use App\Http\Controllers\Product\ProductFeaturesController;
use App\Http\Controllers\Product\ProductImageController;
use App\Http\Controllers\Product\ProductPackagingController;

   /*
    * PRODUCTS START HERE
    */

   /***************************** Product Alternative Units *************************************/
   Route::resource('product-alternative-units', ProductAlternativeUnitsController::class);
   Route::group(['prefix' => 'product-alternative-units'], function () {
      Route::any('/delete', [ProductAlternativeUnitsController::class, 'destroy'])->name('product-alternative-units.destroy');
      Route::any('/changestatus', [ProductAlternativeUnitsController::class, 'changeStatus'])->name('product-alternative-units.changestatus');
      Route::any('/changedefault', [ProductAlternativeUnitsController::class, 'changedefault'])->name('product-alternative-units.changedefault');
   });

   /******************************** Primary-units **************************************/
   Route::resource('primary-units', PrimaryUnitController::class);
   Route::prefix('/primary-units/')->group(function () {
      Route::any('/delete', [PrimaryUnitController::class, 'destroy'])->name('primary-units.destroy');
      Route::any('/change-status', [PrimaryUnitController::class, 'changeStatus'])->name('primary-units.changestatus');
      Route::any('.change-default', [PrimaryUnitController::class, 'changeDefault'])->name('primary-units.change-default');

      // IMPORT/EXPORT
      Route::any('/import/create', [PrimaryUnitController::class, 'importCreate'])->name('primary-units.import-create');
      Route::any('/import/preview', [PrimaryUnitController::class, 'importPreview'])->name('primary-units.import-preview');
      Route::any('/store/import', [PrimaryUnitController::class, 'importStore'])->name('primary-units.import-store');
      Route::any('/export/format', [PrimaryUnitController::class, 'exportFormat'])->name('primary-units.export-format');
      Route::any('/import/session/delete', [PrimaryUnitController::class, 'importSessionDestroy'])->name('primary-units.import-session-destroy');


   });

   /****************************** Product Attributes Types **************************************/
   Route::resource('product-attribute-types', ProductAttributeTypesController::class);
   Route::group(['prefix' => 'product-attribute-types'], function () {
      Route::any('/delete', [ProductAttributeTypesController::class, 'destroy'])->name('product-attribute-types.destroy');
      Route::any('/changestatus', [ProductAttributeTypesController::class, 'changeStatus'])->name('product-attribute-types.changestatus');
      Route::any('/changedefault', [ProductAttributeTypesController::class, 'changedefault'])->name('product-attribute-types.changedefault');
   });

   /********************************** Product Attributes ****************************************/
   Route::resource('product-attributes', ProductAttributesController::class);
   Route::group(['prefix' => 'product-attributes'], function () {
      Route::any('/delete', [ProductAttributesController::class, 'destroy'])->name('product-attributes.destroy');
      Route::any('/changeStatus', [ProductAttributesController::class, 'changeStatus'])->name('product-attributes.changeStatus');
      Route::any('/changedefault', [ProductAttributesController::class, 'changedefault'])->name('product-attributes.changedefault');
   });
   /********************************** Product Brands **************************************/
   Route::resource('product-brands', ProductBrandsController::class);
   Route::group(['prefix' => 'product-brands'], function () {
      Route::any('/delete', [ProductBrandsController::class, 'destroy'])->name('product-brands.destroy');
      Route::any('/changeStatus', [ProductBrandsController::class, 'changeStatus'])->name('product-brands.changeStatus');
      Route::any('/changedefault', [ProductBrandsController::class, 'changedefault'])->name('product-brands.changedefault');
   });
   /********************************** Product Categories ***************************************/
   Route::resource('product-categories', ProductCategoriesController::class);
   Route::group(['prefix' => 'product-categories'], function () {
      Route::any('/delete', [ProductCategoriesController::class, 'destroy'])->name('product-categories.destroy');
      Route::any('/changeStatus', [ProductCategoriesController::class, 'changeStatus'])->name('product-categories.changeStatus');
      Route::any('/changedefault', [ProductCategoriesController::class, 'changedefault'])->name('product-categories.changedefault');
   });
   /************************* Product Groups *********************************/
   Route::resource('product-groups', ProductGroupsController::class);
   Route::group(['prefix' => 'product-groups'], function () {
      Route::any('/delete', [ProductGroupsController::class, 'destroy'])->name('product-groups.destroy');
      Route::any('/changeStatus', [ProductGroupsController::class, 'changeStatus'])->name('product-groups.changeStatus');
      Route::any('/changedefault', [ProductGroupsController::class, 'changedefault'])->name('product-groups.changedefault');
   });

   /******************************* Product item types ********************************/
   Route::resource('product-item-types', ProductItemTypesController::class);
   Route::group(['prefix' => 'product-item-types'], function () {
      Route::any('/delete', [ProductItemTypesController::class, 'destroy'])->name('product-item-types.destroy');
      Route::any('/changeStatus', [ProductItemTypesController::class, 'changeStatus'])->name('product-item-types.changestatus');
      Route::any('/changedefault', [ProductItemTypesController::class, 'changedefault'])->name('product-item-types.changedefault');
   });
   /********************************** Products ********************************/
   Route::resource('products', ProductsController::class);
   Route::group(['prefix' => 'products'], function () {
      Route::any('/delete', [ProductsController::class, 'destroy'])->name('products.destroy');
      Route::any('/changeStatus', [ProductsController::class, 'changeStatus'])->name('products.changeStatus');
      Route::any('/changeIsRawMaterial', [ProductsController::class, 'changeIsRawMaterial'])->name('products.changeIsRawMaterial');
      Route::any('/changeSerialTracking', [ProductsController::class, 'changeSerialTracking'])->name('products.changeSerialTracking');
      Route::any('/changeNegativeStock', [ProductsController::class, 'changeNegativeStock'])->name('products.changeNegativeStock');
      Route::get('/statuses/{id}', [ProductsController::class, 'getstatuses'])->name('products.statuses');
      Route::post('/attributes', [ProductsController::class, 'getAttributes'])->name('products.attributes');
      Route::post('/attributes_sub_group', [ProductsController::class, 'getSubAttributeGroup'])->name('products.attributes_sub_group');
      Route::get('/prices/{id}', [ProductsController::class, 'productPrices'])->name('products.prices');
      Route::get('/images/{id}', [ProductImageController::class, 'index'])->name('products.image');
      Route::any('/additional-info/{id}', [ProductsController::class, 'additionalInfoUpdate'])->name('products.additional_info.update');
      Route::get('/create/modal/', [ProductsController::class, 'createModal'])->name('products.create.modal');
      Route::get('/edit/modal/', [ProductsController::class, 'editModal'])->name('products.edit.modal');
      Route::any('/update/modal/{id}', [ProductsController::class, 'updateModal'])->name('products.modal.update');
      Route::any('/store/modal/', [ProductsController::class, 'StoreModal'])->name('products.modal.store');
   });
      
   Route::post('/search-products', [ProductsController::class, 'searchProducts'])->name('search-products');
   Route::get('products-import/create', [ProductsController::class, 'importProductForm'])->name('products-import.create');
   Route::post('products-import/store', [ProductsController::class, 'importBulkProducts'])->name('products-import.store');
   Route::get('products-import/modal', [ProductsController::class, 'importForm'])->name('products-import.modal');
   Route::get('products-import/edit/{id}', [ProductsController::class, 'editProduct'])->name('products-import.edit');
   Route::post('products-import/update/{id}', [ProductsController::class, 'updateProduct'])->name('products-import.update');
   Route::post('pro\ducts-import/proceed', [ProductsController::class, 'importProducts'])->name('products-import.proceed');
   Route::post('products-import/update_op_stock', [ProductsController::class, 'importUpdateOPStockProducts'])->name('products-import.update_op_stock');
   Route::post('products-import/delete', [ProductsController::class, 'importDestroy'])->name('products-import.destroy');
   //Products export
   Route::any('products-export', [ProductsController::class, 'exportProducts'])->name('products-export');
   Route::get('/product-clear-data', [ProductsController::class, 'clearData'])->name('product-import.clear-data');

   /********************************** Product Warehouse ***********************/
   Route::resource('product-warehouse', ProductWarehouseController::class);
   Route::group(['prefix' => 'product-warehouse'], function () {
      Route::any('/delete', [ProductWarehouseController::class, 'destroy'])->name('product-warehouse.destroy');
      Route::any('/changeStatus', [ProductWarehouseController::class, 'changeStatus'])->name('product-warehouse.changestatus');
      Route::any('/changedefault', [ProductWarehouseController::class, 'changedefault'])->name('product-warehouse.changedefault');
   });
   Route::get('/warehouseCountry', [ProductWarehouseController::class, 'warehouseCountry'])->name('product-warehouse.country');
   /**************************** Product Location Rack **************************/
   Route::resource('product-location-rack', ProductLocationRackController::class);
   Route::group(['prefix' => 'product-location-rack'], function () {
      Route::any('/delete', [ProductLocationRackController::class, 'destroy'])->name('product-location-rack.destroy');
      Route::any('/changeStatus', [ProductLocationRackController::class, 'changeStatus'])->name('product-location-rack.changestatus');
      Route::any('/changedefault', [ProductLocationRackController::class, 'changedefault'])->name('product-location-rack.changedefault');
   });
   /********************************** Product Prices *********************************************/
   Route::resource('product-prices', ProductPricesController::class);
   Route::group(['prefix' => 'product-prices'], function () {
      Route::any('/delete', [ProductPricesController::class, 'destroy'])->name('product-prices.destroy');
      Route::any('/changeStatus', [ProductPricesController::class, 'changeStatus'])->name('product-prices.changeStatus');
   });

   /***************************** Product business divisions ********************************/
   Route::resource('business-divisions', BusinessDivisionController::class);
    Route::prefix('/business-divisions/')->group(function () {
        Route::any('/change-status',[BusinessDivisionController::class,'changeStatus'])->name('business-divisions.changestatus');
        Route::any('/change-default',[BusinessDivisionController::class,'changeDefault'])->name('business-divisions.changedefault');
    });

   /********************************** Product Test Packages ********************************************/
   Route::get('selected-test-packages', [ProductTestPackagesController::class, 'getSelectedTestPackages'])->name('selected-test-packages');
   Route::get('product-test-packages/link/{id}', [ProductTestPackagesController::class, 'create'])->name('product-test-packages.link');
   Route::resource('product-test-packages', ProductTestPackagesController::class);
   Route::get('products/test-packages/{id}', [ProductTestPackagesController::class, 'index'])->name('products.test-packages');
   Route::any('product-test-packages/delete', [ProductTestPackagesController::class, 'destroy'])->name('product-test-packages.destroy');
   Route::post('product-test-packages-reorder', [ProductTestPackagesController::class, 'reorder'])->name('product-test-packages-reorder');
   Route::get('product-test-packages/un-link/{id}', [ProductTestPackagesController::class, 'unlink'])->name('product-test-packages.unlink');

   //Route::get('product-test-packages/selected/{id}', [ProductTestPackagesController::class, 'getSelectedTestPackages'])->name('product-test-packages.selected');
  /********************************** Price list Export & Print ************************************/
   Route::any('/products-price-list', [ProductsController::class, 'productPriceList'])->name('products-price-list');
   Route::any('/products-price-list-view', [ProductsController::class, 'productPriceListView'])->name('products-price-list-view');
   Route::any('/products-price-list-export', [ProductsController::class, 'priceListExport'])->name('products-price-list-export');

      /********************** Product Features ****************************/
      Route::resource('product-features', ProductFeaturesController::class);
      Route::prefix('/product-features/')->group(function () {
         Route::any('/delete',[ProductFeaturesController::class,'destroy'])->name('product-features.destroy');
         Route::any('/change-status',[ProductFeaturesController::class,'changeStatus'])->name('product-features.changestatus');
         Route::any('/change-default',[ProductFeaturesController::class,'changeDefault'])->name('product-features.changedefault');
      });
      /********************** Product Features ****************************/
      Route::any('/product-features-modules/{id}/{code?}',[ProductFeaturesController::class,'productFeatureModule'])->name('product-feature-modules');
      Route::get('product-features-modules-create/{id}', [ProductFeaturesController::class, 'productFeatureModuleCreate'])->name('product-feature-modules.create');
      Route::post('add-all-modules', [ProductFeaturesController::class, 'addAllModules'])->name('all-modules.store');
      // Route::get('product-features-modules-store/{id}', [ProductFeaturesController::class, 'productFeatureModuleCreate'])->name('product-feature-modules.create');
      Route::get('product-features-modules/selected/{id}', [ProductFeaturesController::class, 'getSelectedProductFeatureModule'])->name('product-features.selected');

      /********************************** Product Image *********************************************/
   Route::resource('product-image', ProductImageController::class);
   Route::group(['prefix' => 'product-image'], function () {
      Route::any('/delete', [ProductImageController::class, 'destroy'])->name('product-image.destroy');
      Route::any('/changeStatus', [ProductImageController::class, 'changeStatus'])->name('product-image.changeStatus');
      Route::any('/changeIsDefault', [ProductImageController::class, 'changeIsDefault'])->name('product-image.changeIsDefault');
   });

     /********************************** Product Packaging *********************************************/
   Route::resource('product-packaging', ProductPackagingController::class);
Route::group(['prefix' => 'product-packaging'], function () {
      Route::any('/delete', [ProductPackagingController::class, 'destroy'])->name('product-packaging.destroy');
      Route::any('/changeStatus', [ProductPackagingController::class, 'changeStatus'])->name('product-packaging.changestatus');
   });
//product packaging import
Route::get('product-packaging-import/create', [ProductPackagingController::class, 'importProductForm'])->name('product-packaging-import.create');
   Route::post('product-packaging-import/store', [ProductPackagingController::class, 'importBulkProducts'])->name('product-packaging-import.store');
   Route::get('product-packaging-import/modal', [ProductPackagingController::class, 'importForm'])->name('product-packaging-import.modal');
   Route::get('product-packaging-import/edit/{id}', [ProductPackagingController::class, 'editProduct'])->name('product-packaging-import.edit');
   Route::post('product-packaging-import/update/{id}', [ProductPackagingController::class, 'updateProduct'])->name('product-packaging-import.update');
   Route::post('product-packaging-import/proceed', [ProductPackagingController::class, 'importProducts'])->name('product-packaging-import.proceed');
   Route::post('product-packaging-import/delete', [ProductPackagingController::class, 'importDestroy'])->name('product-packaging-import.destroy');
    Route::get('/product-packaging-clear-data', [ProductPackagingController::class, 'clearData'])->name('product-packaging-import.clear-data');
/********************* Product Batch *******************************8*/
Route::any('batch/create',[ProductBatchController::class,'create'])->name('product.batch.create');
Route::any('batch/edit',[ProductBatchController::class,'edit'])->name('product.batch.edit');
Route::any('batch/store',[ProductBatchController::class,'store'])->name('product.batch.store');
Route::any('batch/update',[ProductBatchController::class,'update'])->name('product.batch.update');
Route::post('/get-batch-wise-price-information', [ProductBatchController::class,'getBatchWisePriceInformation'])->name('get-batch-wise-price-information');

Route::get('/search-product-stock-modal', [ProductsController::class, 'searchStockModal'])->name('product-search-stock-modal');

Route::get('/product-search-stock', [ProductsController::class, 'searchStock'])->name('product-search-stock');



