<?php

use App\Http\Controllers\Purchase\PurchaseInvoiceController;
use Illuminate\Support\Facades\Route;



/************************** Purchase Route ***************************/
Route::group(['prefix' => 'purchase'], function () {
   Route::get('/',[PurchaseInvoiceController::class,'index'])->name('purchase.index');
   Route::any('/create', [PurchaseInvoiceController::class, 'create'])->name('purchase.create');
   Route::any('cart-product-remove', [PurchaseInvoiceController::class, 'cartProductRemove'])->name('purchase-cart-product-remove');
   Route::get('cart-billing', [PurchaseInvoiceController::class, 'billing'])->name('purchase-cart-billing');
   Route::any('purchase-product-add-to-cart', [PurchaseInvoiceController::class, 'productAddToCart'])->name('purchase-product-add-to-cart');
   Route::any('product-cart/{invoice_id?}', [PurchaseInvoiceController::class, 'productCart'])->name('purchase-product-cart');
   Route::any('cart-product-update', [PurchaseInvoiceController::class, 'cartProductUpdate'])->name('purchase-cart-product-update');
   Route::post('store', [PurchaseInvoiceController::class, 'store'])->name('purchase.store');
   Route::get('invoice/{id}', [PurchaseInvoiceController::class, 'invoice'])->name('purchase-invoice');
   Route::any('delete', [PurchaseInvoiceController::class, 'destroy'])->name('purchase.destroy');
   Route::get('edit/{id}', [PurchaseInvoiceController::class, 'edit'])->name('purchase.edit');
   Route::get('edit-cart-billing/{invoice_id}', [PurchaseInvoiceController::class, 'editBilling'])->name('purchase-edit-cart-billing');
   Route::any('update/{id}', [PurchaseInvoiceController::class, 'update'])->name('purchase.update');
   Route::any('search-invoice-from', [PurchaseInvoiceController::class, 'searchInvoiceFrom'])->name('purchase.search-invoice-from');
   Route::post('search-products', [PurchaseInvoiceController::class, 'searchProducts'])->name('purchase-search-products');
   Route::get('collection-create/{invoice_id}', [PurchaseInvoiceController::class, 'collectionCreate'])->name('purchase-collection.create');
   Route::any('collection-store/{invoice_id}', [PurchaseInvoiceController::class, 'collectionStore'])->name('purchase-collection.store');
   Route::any('collection-list/{invoice_id}', [PurchaseInvoiceController::class, 'collectionList'])->name('purchase-collection.list');
   Route::any('statement', [PurchaseInvoiceController::class, 'statement'])->name('purchase.statement');
   Route::any('statement-export', [PurchaseInvoiceController::class, 'statementExport'])->name('purchase.statement-export');

   Route::get('item-wise-statement', [PurchaseInvoiceController::class, 'itemWiseStatement'])->name('purchase.item-wise-statement');
   Route::get('item-wise-statement-export', [PurchaseInvoiceController::class, 'itemWiseStatementExport'])->name('purchase.item-wise-statement-export');
   Route::get('single-product-statement/{id}', [PurchaseInvoiceController::class, 'singleProductStatement'])->name('purchase.single-product-statement');

   Route::get('all_item-wise-statement', [PurchaseInvoiceController::class, 'allItemWiseStatement'])->name('purchase.all_item-wise-statement');
   Route::get('all-item-wise-statement-export', [PurchaseInvoiceController::class, 'allitemWiseStatementExport'])->name('purchase.all-item-wise-statement-export');
});
