<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OpdAppointment\QueueManagerController;




/************************** Queue Manager Route *******************************/
Route::group(['prefix' => 'queue-manager'], function () {
    Route::get('/',[QueueManagerController::class,'index'])->name('queue-manager.index');
    Route::get('/doctor-display/{doctor_id}',[QueueManagerController::class,'doctorDisplay'])->name('queue-manager.doctor.display');
    Route::any('/consultation-start/{booking_id}',[QueueManagerController::class,'consultationStart'])->name('queue-manager.consultation.start');
    Route::any('/visit-done/{booking_id}',[QueueManagerController::class,'visitDone'])->name('queue-manager.patient-visit.done');
    Route::any('/visit-undo/{booking_id}',[QueueManagerController::class,'visitUndo'])->name('queue-manager.patient-visit.undo');

    Route::get('/patient-display/{doctor_id}',[QueueManagerController::class,'doctorDisplay'])->name('queue-manager.patient.display');
});

?>